/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.handler;

import com.codahale.metrics.Meter;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.FormTag;
import j2html.tags.specialized.InputTag;
import j2html.tags.specialized.LinkTag;
import j2html.tags.specialized.OptionTag;
import j2html.tags.specialized.SelectTag;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.daemon.logviewer.utils.DirectoryCleaner;
import org.apache.storm.daemon.logviewer.utils.LogviewerResponseBuilder;
import org.apache.storm.daemon.logviewer.utils.ResourceAuthorizer;
import org.apache.storm.daemon.logviewer.utils.WorkerLogs;
import org.apache.storm.daemon.ui.InvalidRequestException;
import org.apache.storm.daemon.ui.UIHelpers;
import org.apache.storm.daemon.utils.StreamUtil;
import org.apache.storm.daemon.utils.UrlBuilder;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ServerUtils;

public class LogviewerLogPageHandler {
    private final Meter numPageRead;
    private final Meter numFileOpenExceptions;
    private final Meter numFileReadExceptions;
    private final Path logRoot;
    private final Path daemonLogRoot;
    private final WorkerLogs workerLogs;
    private final ResourceAuthorizer resourceAuthorizer;
    private final DirectoryCleaner directoryCleaner;

    public LogviewerLogPageHandler(String logRoot, String daemonLogRoot, WorkerLogs workerLogs, ResourceAuthorizer resourceAuthorizer, StormMetricsRegistry metricsRegistry) {
        this.logRoot = Paths.get(logRoot, new String[0]).toAbsolutePath().normalize();
        this.daemonLogRoot = Paths.get(daemonLogRoot, new String[0]).toAbsolutePath().normalize();
        this.workerLogs = workerLogs;
        this.resourceAuthorizer = resourceAuthorizer;
        this.numPageRead = metricsRegistry.registerMeter("logviewer:num-page-read");
        this.numFileOpenExceptions = metricsRegistry.registerMeter("logviewer:num-file-open-exceptions");
        this.numFileReadExceptions = metricsRegistry.registerMeter("logviewer:num-file-read-exceptions");
        this.directoryCleaner = new DirectoryCleaner(metricsRegistry);
    }

    public Response listLogFiles(String user, Integer port, String topologyId, String callback, String origin) throws IOException {
        List<Path> fileResults = null;
        if (topologyId == null) {
            if (port == null) {
                fileResults = this.workerLogs.getAllLogsForRootDir();
            } else {
                fileResults = new ArrayList<Path>();
                File[] logRootFiles = this.logRoot.toFile().listFiles();
                if (logRootFiles != null) {
                    for (File topoDir : logRootFiles) {
                        File[] topoDirFiles = topoDir.listFiles();
                        if (topoDirFiles == null) continue;
                        for (File portDir : topoDirFiles) {
                            if (!portDir.getName().equals(port.toString())) continue;
                            fileResults.addAll(this.directoryCleaner.getFilesForDir(portDir.toPath()));
                        }
                    }
                }
            }
        } else if (port == null) {
            File[] topoDirFiles;
            fileResults = new ArrayList<Path>();
            Path topoDir = this.logRoot.resolve(topologyId).toAbsolutePath().normalize();
            if (!topoDir.startsWith(this.logRoot)) {
                return LogviewerResponseBuilder.buildSuccessJsonResponse(Collections.emptyList(), callback, origin);
            }
            if (topoDir.toFile().exists() && (topoDirFiles = topoDir.toFile().listFiles()) != null) {
                for (File portDir : topoDirFiles) {
                    fileResults.addAll(this.directoryCleaner.getFilesForDir(portDir.toPath()));
                }
            }
        } else {
            File portDir = ConfigUtils.getWorkerDirFromRoot((String)this.logRoot.toString(), (String)topologyId, (Integer)port).getCanonicalFile();
            if (!portDir.getPath().startsWith(this.logRoot.toString())) {
                return LogviewerResponseBuilder.buildSuccessJsonResponse(Collections.emptyList(), callback, origin);
            }
            if (portDir.exists()) {
                fileResults = this.directoryCleaner.getFilesForDir(portDir.toPath());
            }
        }
        List<Object> files = fileResults != null ? fileResults.stream().map(WorkerLogs::getTopologyPortWorkerLog).sorted().collect(Collectors.toList()) : new ArrayList();
        return LogviewerResponseBuilder.buildSuccessJsonResponse(files, callback, origin);
    }

    public Response logPage(String fileName, Integer start, Integer length, String grep, String user) throws IOException, InvalidRequestException {
        Path rawFile = this.logRoot.resolve(fileName);
        Path absFile = rawFile.toAbsolutePath().normalize();
        if (!absFile.startsWith(this.logRoot) || !rawFile.normalize().toString().equals(rawFile.toString())) {
            return LogviewerResponseBuilder.buildResponsePageNotFound();
        }
        if (this.resourceAuthorizer.isUserAllowedToAccessFile(user, fileName)) {
            this.workerLogs.setLogFilePermission(fileName);
            Path topoDir = absFile.getParent().getParent();
            if (absFile.toFile().exists()) {
                SortedSet logFiles;
                try {
                    logFiles = Arrays.stream(topoDir.toFile().listFiles()).flatMap(portDir -> {
                        try {
                            return this.directoryCleaner.getFilesForDir(portDir.toPath()).stream();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toCollection(TreeSet::new));
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
                List<String> reorderedFilesStr = logFiles.stream().map(WorkerLogs::getTopologyPortWorkerLog).filter(fileStr -> !StringUtils.equals((String)fileName, (String)fileStr)).collect(Collectors.toList());
                reorderedFilesStr.add(fileName);
                length = length != null ? Math.min(0xA00000, length) : 51200;
                boolean isZipFile = absFile.getFileName().toString().endsWith(".gz");
                long fileLength = this.getFileLength(absFile.toFile(), isZipFile);
                if (start == null) {
                    start = Long.valueOf(fileLength - (long)length.intValue()).intValue();
                }
                String logString = this.isTxtFile(fileName) ? StringEscapeUtils.escapeHtml((String)this.pageFile(absFile.toString(), isZipFile, fileLength, start, length)) : StringEscapeUtils.escapeHtml((String)"This is a binary file and cannot display! You may download the full file.");
                ArrayList<DomContent> bodyContents = new ArrayList<DomContent>();
                if (StringUtils.isNotEmpty((String)grep)) {
                    String matchedString = String.join((CharSequence)"\n", Arrays.stream(logString.split("\n")).filter(str -> str.contains(grep)).collect(Collectors.toList()));
                    bodyContents.add((DomContent)TagCreator.pre((String)matchedString).withId("logContent"));
                } else {
                    DomContent pagerData = null;
                    if (this.isTxtFile(fileName)) {
                        pagerData = this.pagerLinks(fileName, start, length, Long.valueOf(fileLength).intValue(), "log");
                    }
                    bodyContents.add(this.searchFileForm(fileName, "no"));
                    bodyContents.add(this.logFileSelectionForm(reorderedFilesStr, fileName, "log"));
                    if (pagerData != null) {
                        bodyContents.add(pagerData);
                    }
                    bodyContents.add(this.downloadLink(fileName));
                    bodyContents.add((DomContent)TagCreator.pre((String)logString).withClass("logContent"));
                    if (pagerData != null) {
                        bodyContents.add(pagerData);
                    }
                }
                String content = this.logTemplate(bodyContents, fileName, user).render();
                return LogviewerResponseBuilder.buildSuccessHtmlResponse(content);
            }
            return LogviewerResponseBuilder.buildResponsePageNotFound();
        }
        if (this.resourceAuthorizer.getLogUserGroupWhitelist(fileName) == null) {
            return LogviewerResponseBuilder.buildResponsePageNotFound();
        }
        return LogviewerResponseBuilder.buildResponseUnauthorizedUser(user);
    }

    public Response daemonLogPage(String fileName, Integer start, Integer length, String grep, String user) throws IOException, InvalidRequestException {
        Path file = this.daemonLogRoot.resolve(fileName).toAbsolutePath().normalize();
        if (!file.startsWith(this.daemonLogRoot) || Paths.get(fileName, new String[0]).getNameCount() != 1) {
            return LogviewerResponseBuilder.buildResponsePageNotFound();
        }
        if (file.toFile().exists()) {
            List logFiles = Arrays.stream(this.daemonLogRoot.toFile().listFiles()).filter(File::isFile).collect(Collectors.toList());
            List<String> reorderedFilesStr = logFiles.stream().map(File::getName).filter(fName -> !StringUtils.equals((String)fileName, (String)fName)).collect(Collectors.toList());
            reorderedFilesStr.add(fileName);
            length = length != null ? Math.min(0xA00000, length) : 51200;
            boolean isZipFile = file.getFileName().toString().endsWith(".gz");
            long fileLength = this.getFileLength(file.toFile(), isZipFile);
            if (start == null) {
                start = Long.valueOf(fileLength - (long)length.intValue()).intValue();
            }
            String logString = this.isTxtFile(fileName) ? StringEscapeUtils.escapeHtml((String)this.pageFile(file.toString(), isZipFile, fileLength, start, length)) : StringEscapeUtils.escapeHtml((String)"This is a binary file and cannot display! You may download the full file.");
            ArrayList<DomContent> bodyContents = new ArrayList<DomContent>();
            if (StringUtils.isNotEmpty((String)grep)) {
                String matchedString = String.join((CharSequence)"\n", Arrays.stream(logString.split("\n")).filter(str -> str.contains(grep)).collect(Collectors.toList()));
                bodyContents.add((DomContent)TagCreator.pre((String)matchedString).withId("logContent"));
            } else {
                DomContent pagerData = null;
                if (this.isTxtFile(fileName)) {
                    pagerData = this.pagerLinks(fileName, start, length, Long.valueOf(fileLength).intValue(), "daemonlog");
                }
                bodyContents.add(this.searchFileForm(fileName, "yes"));
                bodyContents.add(this.logFileSelectionForm(reorderedFilesStr, fileName, "daemonlog"));
                if (pagerData != null) {
                    bodyContents.add(pagerData);
                }
                bodyContents.add(this.daemonDownloadLink(fileName));
                bodyContents.add((DomContent)TagCreator.pre((String)logString).withClass("logContent"));
                if (pagerData != null) {
                    bodyContents.add(pagerData);
                }
            }
            String content = this.logTemplate(bodyContents, fileName, user).render();
            return LogviewerResponseBuilder.buildSuccessHtmlResponse(content);
        }
        return LogviewerResponseBuilder.buildResponsePageNotFound();
    }

    private long getFileLength(File file, boolean isZipFile) throws IOException {
        try {
            return isZipFile ? ServerUtils.zipFileSize((File)file) : file.length();
        }
        catch (FileNotFoundException e) {
            this.numFileOpenExceptions.mark();
            throw e;
        }
        catch (IOException e) {
            this.numFileReadExceptions.mark();
            throw e;
        }
    }

    private DomContent logTemplate(List<DomContent> bodyContents, String fileName, String user) {
        ArrayList<Object> finalBodyContents = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)user)) {
            finalBodyContents.add(TagCreator.div((DomContent[])new DomContent[]{TagCreator.p((String)("User: " + user))}).withClass("ui-user"));
        }
        finalBodyContents.add(TagCreator.div((DomContent[])new DomContent[]{TagCreator.p((String)"Note: the drop-list shows at most 1024 files for each worker directory.")}).withClass("ui-note"));
        finalBodyContents.add(TagCreator.h3((String)StringEscapeUtils.escapeHtml((String)fileName)));
        finalBodyContents.addAll(bodyContents);
        return TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)(StringEscapeUtils.escapeHtml((String)fileName) + " - Storm Log Viewer")), ((LinkTag)TagCreator.link().withRel("stylesheet")).withHref("/css/bootstrap-3.3.1.min.css"), ((LinkTag)TagCreator.link().withRel("stylesheet")).withHref("/css/jquery.dataTables.1.10.4.min.css"), ((LinkTag)TagCreator.link().withRel("stylesheet")).withHref("/css/style.css")}), TagCreator.body((DomContent[])finalBodyContents.toArray(new DomContent[0]))});
    }

    private DomContent downloadLink(String fileName) {
        return TagCreator.p((DomContent[])new DomContent[]{this.linkTo(UIHelpers.urlFormat("/api/v1/download?file=%s", fileName), "Download Full File")});
    }

    private DomContent daemonDownloadLink(String fileName) {
        return TagCreator.p((DomContent[])new DomContent[]{this.linkTo(UIHelpers.urlFormat("/api/v1/daemondownload?file=%s", fileName), "Download Full File")});
    }

    private DomContent linkTo(String url, String content) {
        return TagCreator.a((String)content).withHref(url);
    }

    private DomContent logFileSelectionForm(List<String> logFiles, String selectedFile, String type) {
        return ((FormTag)TagCreator.form((DomContent[])new DomContent[]{this.dropDown("file", logFiles, selectedFile), ((InputTag)TagCreator.input().withType("submit")).withValue("Switch file")}).withAction(type)).withId("list-of-files");
    }

    private DomContent dropDown(String name, List<String> logFiles, String selectedFile) {
        List<DomContent> options = logFiles.stream().map(file -> (OptionTag)TagCreator.option((String)file).condAttr(file.equals(selectedFile), "selected", "selected")).collect(Collectors.toList());
        return ((SelectTag)((SelectTag)TagCreator.select((DomContent[])options.toArray(new DomContent[0])).withName(name)).withId(name)).attr("value", (Object)selectedFile);
    }

    private DomContent searchFileForm(String fileName, String isDaemonValue) {
        return ((FormTag)TagCreator.form((DomContent[])new DomContent[]{TagCreator.text((String)"search this file:"), ((InputTag)TagCreator.input().withType("text")).withName("search"), ((InputTag)((InputTag)TagCreator.input().withType("hidden")).withName("is-daemon")).withValue(isDaemonValue), ((InputTag)((InputTag)TagCreator.input().withType("hidden")).withName("file")).withValue(fileName), ((InputTag)TagCreator.input().withType("submit")).withValue("Search")}).withAction("/logviewer_search.html")).withId("search-box");
    }

    private DomContent pagerLinks(String fileName, Integer start, Integer length, Integer fileLength, String type) {
        HashMap<String, Object> urlQueryParams = new HashMap<String, Object>();
        urlQueryParams.put("file", fileName);
        urlQueryParams.put("start", Math.max(0, start - length));
        urlQueryParams.put("length", length);
        ArrayList<DomContent> btnLinks = new ArrayList<DomContent>();
        int prevStart = Math.max(0, start - length);
        btnLinks.add(this.toButtonLink(UrlBuilder.build("/api/v1/" + type, urlQueryParams), "Prev", prevStart < start));
        urlQueryParams.clear();
        urlQueryParams.put("file", fileName);
        urlQueryParams.put("start", 0);
        urlQueryParams.put("length", length);
        btnLinks.add(this.toButtonLink(UrlBuilder.build("/api/v1/" + type, urlQueryParams), "First"));
        urlQueryParams.clear();
        urlQueryParams.put("file", fileName);
        urlQueryParams.put("length", length);
        btnLinks.add(this.toButtonLink(UrlBuilder.build("/api/v1/" + type, urlQueryParams), "Last"));
        urlQueryParams.clear();
        urlQueryParams.put("file", fileName);
        urlQueryParams.put("start", Math.min(Math.max(0, fileLength - length), start + length));
        urlQueryParams.put("length", length);
        int nextStart = fileLength > 0 ? Math.min(Math.max(0, fileLength - length), start + length) : start + length;
        btnLinks.add(this.toButtonLink(UrlBuilder.build("/api/v1/" + type, urlQueryParams), "Next", nextStart > start));
        return TagCreator.div((DomContent[])btnLinks.toArray(new DomContent[0]));
    }

    private DomContent toButtonLink(String url, String text) {
        return this.toButtonLink(url, text, true);
    }

    private DomContent toButtonLink(String url, String text, boolean enabled) {
        return ((ATag)TagCreator.a((String)text).withHref(url)).withClass("btn btn-default " + (enabled ? "enabled" : "disabled"));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String pageFile(String path, boolean isZipFile, long fileLength, Integer start, Integer readLength) throws IOException, InvalidRequestException {
        try (InputStream input = isZipFile ? new GZIPInputStream(new FileInputStream(path)) : new FileInputStream(path);){
            String string;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int size;
                if ((long)start.intValue() >= fileLength) {
                    throw new InvalidRequestException("Cannot start past the end of the file");
                }
                if (start > 0) {
                    StreamUtil.skipBytes(input, start);
                }
                byte[] buffer = new byte[1024];
                while (output.size() < readLength && (size = input.read(buffer, 0, Math.min(1024, readLength - output.size()))) > 0) {
                    output.write(buffer, 0, size);
                }
                this.numPageRead.mark();
                string = output.toString();
            }
            return string;
        }
        catch (FileNotFoundException e) {
            this.numFileOpenExceptions.mark();
            throw e;
        }
        catch (IOException e) {
            this.numFileReadExceptions.mark();
            throw e;
        }
    }

    private boolean isTxtFile(String fileName) {
        Pattern p = Pattern.compile("\\.(log.*|txt|yaml|pid)$");
        Matcher matcher = p.matcher(fileName);
        return matcher.find();
    }
}

