/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.servlets;

import com.codahale.metrics.jvm.ThreadDump;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;

public class ThreadDumpServlet
extends HttpServlet {
    private static final long serialVersionUID = -2690343532336103046L;
    private static final String CONTENT_TYPE = "text/plain";
    private transient ThreadDump threadDump;

    public void init() throws ServletException {
        try {
            this.threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        }
        catch (NoClassDefFoundError ncdfe) {
            this.threadDump = null;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean includeMonitors = ThreadDumpServlet.getParam(req.getParameter("monitors"), true);
        boolean includeSynchronizers = ThreadDumpServlet.getParam(req.getParameter("synchronizers"), true);
        resp.setStatus(200);
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        if (this.threadDump == null) {
            resp.getWriter().println("Sorry your runtime environment does not allow to dump threads.");
            return;
        }
        try (ServletOutputStream output = resp.getOutputStream();){
            this.threadDump.dump(includeMonitors, includeSynchronizers, (OutputStream)output);
        }
    }

    private static Boolean getParam(String initParam, boolean defaultValue) {
        return initParam == null ? defaultValue : Boolean.parseBoolean(initParam);
    }
}

