/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.datasource.socket.trident;

import java.io.IOException;
import java.util.List;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.datasource.socket.trident.SocketState;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.BaseStateUpdater;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketStateUpdater
extends BaseStateUpdater<SocketState> {
    private static final Logger LOG = LoggerFactory.getLogger(SocketStateUpdater.class);
    private final IOutputSerializer outputSerializer;

    public SocketStateUpdater(IOutputSerializer outputSerializer) {
        this.outputSerializer = outputSerializer;
    }

    public void updateState(SocketState state, List<TridentTuple> tuples, TridentCollector collector) {
        try {
            for (TridentTuple tuple : tuples) {
                byte[] array = this.outputSerializer.write(tuple.getValues(), null).array();
                String data = new String(array);
                state.write(data + "\n");
            }
            state.flush();
        }
        catch (IOException e) {
            LOG.error("Error while updating state.", (Throwable)e);
            collector.reportError((Throwable)e);
            throw new RuntimeException("Error while updating state.", e);
        }
    }
}

