/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstaller;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;

@Mojo(name="include-artifact", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class IncludeArtifactMojo
extends AbstractIncludingFeatureMojo {
    public static final String CFG_CLASSIFIER = "includeArtifactClassifier";
    public static final String CFG_START_ORDER = "bundleStartOrder";
    public static final String CFG_INCLUDE_DEPENDENCIES_WITH_SCOPE = "includeDependenciesWithScope";
    @Parameter(property="includeArtifactClassifier", required=false)
    private String includeArtifactClassifier;
    @Parameter(property="bundleStartOrder", required=false, defaultValue="-1")
    private int bundlesStartOrder;
    @Parameter(property="includeDependenciesWithScope", required=false)
    private String[] includeDependenciesWithScope;
    @Parameter
    private String includeArtifactExtension;
    @Parameter
    private String includeClassifier;
    @Parameter
    private String includeType;
    @Parameter
    private Map<String, String> metadata;
    @Component
    protected ArtifactInstaller installer;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        Map<String, Feature> featuresMap = ProjectHelper.getFeatures(this.project);
        Feature found = null;
        String key = null;
        for (Map.Entry<String, Feature> entry : featuresMap.entrySet()) {
            if (this.includeArtifactClassifier == null || !this.includeArtifactClassifier.equals(entry.getValue().getId().getClassifier())) continue;
            key = entry.getKey();
            found = entry.getValue();
            break;
        }
        File file = null;
        if (found == null) {
            found = new Feature(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.includeArtifactClassifier, "slingosgifeature"));
            file = new File(this.getTmpDir(), "feature" + (String)(this.includeArtifactClassifier == null ? "" : "-" + this.includeArtifactClassifier) + ".json");
            key = file.getAbsolutePath();
            ProjectHelper.getFeatures(this.project).put(key, found);
            ProjectHelper.getAssembledFeatures(this.project).put(key, found);
        }
        Artifact art = new Artifact(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.includeClassifier, this.includeType != null ? this.includeType : this.project.getArtifact().getType()));
        if (this.jarStartOrder > 0) {
            art.setStartOrder(this.jarStartOrder);
        }
        if (this.metadata != null && this.metadata.size() > 0) {
            art.getMetadata().putAll(this.metadata);
        }
        this.includeArtifact(found, this.includeArtifactExtension, art);
        this.includeArtifact(ProjectHelper.getAssembledFeatures(this.project).get(key), this.includeArtifactExtension, art.copy(art.getId()));
        this.addDependencies(found);
        if (file != null) {
            try (FileWriter writer = new FileWriter(file);){
                FeatureJSONWriter.write((Writer)writer, (Feature)found);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to write feature", (Exception)ioe);
            }
        }
    }

    private void includeArtifact(Feature f, String extensionName, Artifact art) throws MojoExecutionException {
        Bundles container = f.getBundles();
        if (extensionName != null) {
            Extension ext = f.getExtensions().getByName(extensionName);
            if (ext == null) {
                ext = new Extension(ExtensionType.ARTIFACTS, extensionName, ExtensionState.REQUIRED);
                f.getExtensions().add((Object)ext);
            }
            if (ext.getType() != ExtensionType.ARTIFACTS) {
                throw new MojoExecutionException("Wrong extension type for extension " + extensionName + " : " + String.valueOf(ext.getType()));
            }
            container = ext.getArtifacts();
        }
        container.add(art);
    }

    private void addDependencies(Feature feature) {
        for (String includeDependencyScope : this.includeDependenciesWithScope) {
            List dependencies = this.project.getDependencies();
            for (Dependency dependency : dependencies) {
                if (!includeDependencyScope.equals(dependency.getScope())) continue;
                ArtifactId id = new ArtifactId(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType());
                Artifact artifact = new Artifact(id);
                if (this.bundlesStartOrder >= 0) {
                    artifact.setStartOrder(this.bundlesStartOrder);
                }
                feature.getBundles().add(artifact);
            }
        }
    }
}

