/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.maven.bundlesupport.AbstractBundleInstallMojo;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL)
public class BundleInstallMojo
extends AbstractBundleInstallMojo {
    @Parameter(property="sling.install.skip", defaultValue="false")
    private boolean skip;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping bundle installation as instructed");
            return;
        }
        super.execute();
    }

    @Override
    protected File getBundleFileName() throws MojoExecutionException {
        File file = this.project.getArtifact().getFile();
        if (this.isBundleFile(file)) {
            return file;
        }
        this.getLog().debug((CharSequence)("No bundle found in primary artifact " + file + ", checking secondary ones..."));
        for (Artifact artifact : this.project.getAttachedArtifacts()) {
            if (this.isBundleFile(artifact.getFile())) {
                return file;
            }
            this.getLog().debug((CharSequence)("No bundle found in secondary artifact " + file));
        }
        throw new MojoExecutionException("No attached bundle found for this Maven project, for standalone usage use goal 'install-file' instead!");
    }

    private boolean isBundleFile(File file) {
        if (file == null) {
            return false;
        }
        return this.getBundleSymbolicName(file) != null;
    }
}

