/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.kickstart.run;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.maven.kickstart.run.ProcessDescription;

public class ProcessDescriptionProvider {
    private static final String DEFAULT_KEY = "DEFAULT_LAUNCHPAD";
    private static ProcessDescriptionProvider ourInstance = new ProcessDescriptionProvider();
    private final Map<String, ProcessDescription> configs = new HashMap<String, ProcessDescription>();
    private final Map<String, String> lockedIds = new HashMap<String, String>();

    private ProcessDescriptionProvider() {
    }

    public static ProcessDescriptionProvider getInstance() {
        return ourInstance;
    }

    public synchronized String getId(String kickstartId) throws Exception {
        String id;
        String string = id = kickstartId == null ? DEFAULT_KEY : kickstartId;
        if (this.configs.containsKey(id) || this.lockedIds.containsKey(id)) {
            throw new Exception("Kickstart Id " + id + " is already in use");
        }
        String ts = String.valueOf(System.currentTimeMillis());
        this.lockedIds.put(id, ts);
        return ts;
    }

    public synchronized boolean cancelId(String kickstartId, String unlockKey) {
        String id;
        String string = id = kickstartId == null ? DEFAULT_KEY : kickstartId;
        if (this.lockedIds.containsKey(id) && this.lockedIds.get(id).equals(unlockKey)) {
            this.lockedIds.remove(id);
            return true;
        }
        return false;
    }

    public synchronized ProcessDescription getRunConfiguration(String kickstartId) {
        String id = kickstartId == null ? DEFAULT_KEY : kickstartId;
        return this.configs.get(id);
    }

    public synchronized boolean isRunConfigurationAvailable(String kickstartId) {
        return this.getRunConfiguration(kickstartId) == null && !this.lockedIds.containsKey(kickstartId);
    }

    public synchronized void addRunConfiguration(ProcessDescription cfg, String unlockKey) throws Exception {
        String id;
        String string = id = cfg.getId() == null ? DEFAULT_KEY : cfg.getId();
        if (!this.lockedIds.containsKey(id) || !this.lockedIds.get(id).equals(unlockKey)) {
            throw new Exception("Cannot add configuration. Id " + id + " doesn't exist");
        }
        this.lockedIds.remove(cfg.getId());
        this.configs.put(cfg.getId(), cfg);
    }

    public synchronized void removeRunConfiguration(String kickstartId) {
        String id = kickstartId == null ? DEFAULT_KEY : kickstartId;
        this.configs.remove(id);
    }
}

