/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.access.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;

public class RestrictionItem {
    private RestrictionDefinition rd;
    private Object value;
    private boolean exists;

    public RestrictionItem(RestrictionDefinition rd, Object value, boolean exists) {
        this.rd = rd;
        this.value = value;
        this.exists = exists;
    }

    public String getName() {
        return this.rd.getName();
    }

    public boolean isMultiValue() {
        return this.rd.getRequiredType().isArray();
    }

    public String getValue() throws RepositoryException {
        String v = null;
        Object object = this.value;
        if (object instanceof Value) {
            Value valueObj = (Value)object;
            v = valueObj.getString();
        } else {
            object = this.value;
            if (object instanceof Value[]) {
                Value[] va = (Value[])object;
                if (va.length > 0) {
                    v = va[0].getString();
                }
            } else {
                object = this.value;
                if (object instanceof String) {
                    String valueString;
                    v = valueString = (String)object;
                } else {
                    String[] values;
                    object = this.value;
                    if (object instanceof String[] && (values = (String[])object).length > 0) {
                        v = values[0];
                    }
                }
            }
        }
        if (v == null) {
            v = "";
        }
        return v;
    }

    public List<String> getValues() throws RepositoryException {
        ArrayList<String> values = new ArrayList<String>();
        Object object = this.value;
        if (object instanceof Value) {
            Value valueObj = (Value)object;
            values.add(valueObj.getString());
        } else {
            Object object2 = this.value;
            if (object2 instanceof Value[]) {
                Value[] va;
                for (Value v : va = (Value[])object2) {
                    values.add(v.getString());
                }
            } else {
                Object object3 = this.value;
                if (object3 instanceof String) {
                    String stringValue = (String)object3;
                    values.add(stringValue);
                } else {
                    Object object4 = this.value;
                    if (object4 instanceof String[]) {
                        String[] stringValues = (String[])object4;
                        values.addAll(Arrays.asList(stringValues));
                    }
                }
            }
        }
        if (values.isEmpty()) {
            values.add("");
        }
        return values;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public boolean isMandatory() {
        return this.rd.isMandatory();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RestrictionItem [name=");
        builder.append(this.rd.getName());
        builder.append(", value=");
        try {
            builder.append(this.getValues());
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        builder.append(", exists=");
        builder.append(this.exists);
        builder.append("]");
        return builder.toString();
    }
}

