/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.iterator.tree;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.impl.iterator.AbstractIterator;

public class BfsTreeIterator<T>
extends AbstractIterator<T> {
    private final Deque<T> queue = new LinkedList<T>();
    private final TreeProvider<T> provider;
    private Iterator<T> currentIterator;

    public BfsTreeIterator(T root, TreeProvider<T> provider) {
        this.currentIterator = provider.listChildren(root);
        this.provider = provider;
    }

    @Override
    protected T getElement() {
        if (this.currentIterator.hasNext()) {
            T resource = this.currentIterator.next();
            this.queue.add(resource);
            return resource;
        }
        if (!this.queue.isEmpty()) {
            this.currentIterator = this.provider.listChildren(this.queue.pop());
            return this.getElement();
        }
        return null;
    }
}

