/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.ActivityViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.sling.jcr.base.internal.mount.ProxyItem;
import org.apache.sling.jcr.base.internal.mount.ProxySession;

public class ProxyNode
extends ProxyItem<Node>
implements Node {
    public ProxyNode(ProxySession mountSession, Node node) {
        super(mountSession, node);
    }

    public Node addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.mountSession.addNode(this.getPath(), this.concat(this.getPath(), relPath), relPath);
    }

    public Node addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        return this.mountSession.addNode(this.getPath(), this.concat(this.getPath(), relPath), relPath, primaryNodeTypeName);
    }

    public void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        ((Node)this.delegate).orderBefore(srcChildRelPath, destChildRelPath);
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value, type));
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, values));
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, values, type));
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, values));
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, values, type));
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value, type));
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Property setProperty(String name, Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Property setProperty(String name, BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).setProperty(name, value));
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        return this.mountSession.getNode(this.concat(this.getPath(), relPath));
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.mountSession.getNodes(this.getPath(), ((Node)this.delegate).getNodes());
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        return this.mountSession.getNodes(this.getPath(), ((Node)this.delegate).getNodes(namePattern));
    }

    public NodeIterator getNodes(String[] nameGlobs) throws RepositoryException {
        return this.mountSession.getNodes(this.getPath(), ((Node)this.delegate).getNodes(nameGlobs));
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getProperty(relPath));
    }

    public PropertyIterator getProperties() throws RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getProperties());
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getProperties(namePattern));
    }

    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getProperties(nameGlobs));
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getPrimaryItem());
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        return ((Node)this.delegate).getUUID();
    }

    public String getIdentifier() throws RepositoryException {
        return ((Node)this.delegate).getIdentifier();
    }

    public int getIndex() throws RepositoryException {
        return ((Node)this.delegate).getIndex();
    }

    public PropertyIterator getReferences() throws RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getReferences());
    }

    public PropertyIterator getReferences(String name) throws RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getReferences(name));
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getWeakReferences());
    }

    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getWeakReferences(name));
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        return this.mountSession.nodeExists(this.concat(this.getPath(), relPath));
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        return this.mountSession.propertyExists(this.concat(this.getPath(), relPath));
    }

    public boolean hasNodes() throws RepositoryException {
        return this.mountSession.hasNodes((Node)this.delegate);
    }

    public boolean hasProperties() throws RepositoryException {
        return ((Node)this.delegate).hasProperties();
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        return ((Node)this.delegate).getPrimaryNodeType();
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        return ((Node)this.delegate).getMixinNodeTypes();
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return ((Node)this.delegate).isNodeType(nodeTypeName);
    }

    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        ((Node)this.delegate).setPrimaryType(nodeTypeName);
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        ((Node)this.delegate).addMixin(mixinName);
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        ((Node)this.delegate).removeMixin(mixinName);
    }

    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        return ((Node)this.delegate).canAddMixin(mixinName);
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        return ((Node)this.delegate).getDefinition();
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        return ((Node)this.delegate).checkin();
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, ActivityViolationException, RepositoryException {
        ((Node)this.delegate).checkout();
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        ((Node)this.delegate).doneMerge(version);
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        ((Node)this.delegate).cancelMerge(version);
    }

    public void update(String srcWorkspace) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        ((Node)this.delegate).update(srcWorkspace);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).merge(srcWorkspace, bestEffort));
    }

    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        return ((Node)this.delegate).getCorrespondingNodePath(workspaceName);
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getSharedSet());
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        ((Node)this.delegate).removeSharedSet();
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        ((Node)this.delegate).removeShare();
    }

    public boolean isCheckedOut() throws RepositoryException {
        return ((Node)this.delegate).isCheckedOut();
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        ((Node)this.delegate).restore(versionName, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        ((Node)this.delegate).restore(version, removeExisting);
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        ((Node)this.delegate).restore(version, relPath, removeExisting);
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        ((Node)this.delegate).restoreByLabel(versionLabel, removeExisting);
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return ((Node)this.delegate).getVersionHistory();
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        return ((Node)this.delegate).getBaseVersion();
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).lock(isDeep, isSessionScoped));
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        return this.mountSession.wrap(((Node)this.delegate).getLock());
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        ((Node)this.delegate).unlock();
    }

    public boolean holdsLock() throws RepositoryException {
        return ((Node)this.delegate).holdsLock();
    }

    public boolean isLocked() throws RepositoryException {
        return ((Node)this.delegate).isLocked();
    }

    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
        ((Node)this.delegate).followLifecycleTransition(transition);
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        return ((Node)this.delegate).getAllowedLifecycleTransistions();
    }
}

