/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONReader;

public class ArchiveReader {
    public static Set<Feature> read(InputStream in, ArtifactConsumer consumer) throws IOException {
        JarInputStream jis = new JarInputStream(in);
        String[] featureIds = ArchiveReader.checkHeaderAndExtractContents(jis.getManifest());
        List featurePaths = Arrays.asList(featureIds).stream().map(id -> ArtifactId.fromMvnId((String)id).toMvnPath()).collect(Collectors.toList());
        HashSet<Feature> features = new HashSet<Feature>();
        HashSet<ArtifactId> artifacts = new HashSet<ArtifactId>();
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (!entry.isDirectory() && !entry.getName().startsWith("META-INF/")) {
                if (featurePaths.contains(entry.getName())) {
                    features.add(FeatureJSONReader.read(new InputStreamReader((InputStream)jis, "UTF-8"), entry.getName()));
                } else {
                    ArtifactId id2 = ArtifactId.fromMvnPath((String)entry.getName());
                    if (consumer != null) {
                        consumer.consume(id2, jis);
                    }
                    artifacts.add(id2);
                }
            }
            jis.closeEntry();
        }
        if (features.isEmpty()) {
            throw new IOException("Not a feature model archive - feature file is missing.");
        }
        for (Feature feature : features) {
            for (Artifact a : feature.getBundles()) {
                if (artifacts.contains(a.getId())) continue;
                throw new IOException("Artifact " + a.getId().toMvnId() + " is missing in archive");
            }
            for (Extension e : feature.getExtensions()) {
                if (e.getType() != ExtensionType.ARTIFACTS) continue;
                for (Artifact a : e.getArtifacts()) {
                    if (artifacts.contains(a.getId())) continue;
                    throw new IOException("Artifact " + a.getId().toMvnId() + " is missing in archive");
                }
            }
        }
        return features;
    }

    private static String[] checkHeaderAndExtractContents(Manifest manifest) throws IOException {
        if (manifest == null) {
            throw new IOException("Not a feature model archive - manifest is missing.");
        }
        String version = manifest.getMainAttributes().getValue("Feature-Archive-Version");
        if (version == null) {
            throw new IOException("Not a feature model archive - version manifest header is missing.");
        }
        try {
            int number = Integer.valueOf(version);
            if (number < 1 || number > 1) {
                throw new IOException("Not a feature model archive - invalid manifest header value: " + version);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Not a feature model archive - invalid manifest header value: " + version);
        }
        String contents = manifest.getMainAttributes().getValue("Feature-Archive-Contents");
        if (contents == null) {
            throw new IOException("Not a feature model archive - contents manifest header is missing.");
        }
        return contents.split(",");
    }

    @FunctionalInterface
    public static interface ArtifactConsumer {
        public void consume(ArtifactId var1, InputStream var2) throws IOException;
    }
}

