/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.launcher.spi.LauncherRunContext;
import org.slf4j.Logger;

public class Installation
implements LauncherRunContext {
    private final Map<String, String> fwkProperties = new HashMap<String, String>();
    private final Map<Integer, List<URL>> bundleMap = new HashMap<Integer, List<URL>>();
    private final List<URL> installables = new ArrayList<URL>();
    private final List<Object[]> configurations = new ArrayList<Object[]>();
    private final List<URL> appJars = new ArrayList<URL>();
    private volatile Logger logger;

    public void addAppJar(URL jar) {
        this.appJars.add(jar);
    }

    public List<URL> getAppJars() {
        return this.appJars;
    }

    public void addBundle(Integer startLevel, URL file) {
        List<URL> files = this.bundleMap.get(startLevel);
        if (files == null) {
            files = new ArrayList<URL>();
            this.bundleMap.put(startLevel, files);
        }
        files.add(file);
    }

    public void addInstallableArtifact(URL file) {
        this.installables.add(file);
    }

    public void addConfiguration(String pid, String factoryPid, Dictionary<String, Object> properties) {
        this.configurations.add(new Object[]{pid, factoryPid, properties});
    }

    @Override
    public Map<String, String> getFrameworkProperties() {
        return this.fwkProperties;
    }

    public void addFrameworkProperty(String key, String value) {
        this.fwkProperties.put(key, value);
    }

    @Override
    public Map<Integer, List<URL>> getBundleMap() {
        return this.bundleMap;
    }

    @Override
    public List<Object[]> getConfigurations() {
        return this.configurations;
    }

    @Override
    public List<URL> getInstallableArtifacts() {
        return this.installables;
    }

    public void clear() {
        this.configurations.clear();
        this.fwkProperties.clear();
        this.bundleMap.clear();
        this.installables.clear();
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

