/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.webdav.bind;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.DavException;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.bind.BindConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.xml.DomUtil;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.xml.ElementIterator;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.xml.XmlSerializable;

public class BindInfo
implements XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(BindInfo.class);
    private String segment;
    private String href;

    public BindInfo(String href, String segment) {
        this.href = href;
        this.segment = segment;
    }

    public String getHref() {
        return this.href;
    }

    public String getSegment() {
        return this.segment;
    }

    public static BindInfo createFromXml(Element root) throws DavException {
        if (!DomUtil.matches(root, "bind", BindConstants.NAMESPACE)) {
            log.warn("DAV:bind element expected");
            throw new DavException(400);
        }
        String href = null;
        String segment = null;
        ElementIterator it = DomUtil.getChildren(root);
        while (it.hasNext()) {
            Element elt = it.nextElement();
            if (DomUtil.matches(elt, "segment", BindConstants.NAMESPACE)) {
                if (segment == null) {
                    segment = DomUtil.getText(elt);
                    continue;
                }
                log.warn("unexpected multiple occurrence of DAV:segment element");
                throw new DavException(400);
            }
            if (DomUtil.matches(elt, "href", BindConstants.NAMESPACE)) {
                if (href == null) {
                    href = DomUtil.getText(elt);
                    continue;
                }
                log.warn("unexpected multiple occurrence of DAV:href element");
                throw new DavException(400);
            }
            log.warn("unexpected element " + elt.getLocalName());
            throw new DavException(400);
        }
        if (href == null) {
            log.warn("DAV:href element expected");
            throw new DavException(400);
        }
        if (segment == null) {
            log.warn("DAV:segment element expected");
            throw new DavException(400);
        }
        return new BindInfo(href, segment);
    }

    @Override
    public Element toXml(Document document) {
        Element bindElt = DomUtil.createElement(document, "bind", BindConstants.NAMESPACE);
        Element hrefElt = DomUtil.createElement(document, "href", BindConstants.NAMESPACE, this.href);
        Element segElt = DomUtil.createElement(document, "segment", BindConstants.NAMESPACE, this.segment);
        bindElt.appendChild(hrefElt);
        bindElt.appendChild(segElt);
        return bindElt;
    }
}

