/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.leakdetector.internal;

import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakDetector
implements Runnable,
BundleActivator {
    private final Set<Reference<?>> refs = Collections.synchronizedSet(new HashSet());
    private final Object leakDetectorLock = new Object();
    private final ReferenceQueue<ClassLoader> queue = new ReferenceQueue();
    private final ConcurrentMap<Long, BundleInfo> bundleInfos = new ConcurrentHashMap<Long, BundleInfo>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Thread referencePoller;
    private BundleContext context;
    private BundleTracker bundleTracker;

    public void start(BundleContext context) {
        this.context = context;
        this.bundleTracker = new LeakDetectorBundleTracker(context);
        this.referencePoller = new Thread((Runnable)this, "Bundle Leak Detector Thread");
        this.referencePoller.setDaemon(true);
        this.referencePoller.start();
        Hashtable<String, String> printerProps = new Hashtable<String, String>();
        ((Dictionary)printerProps).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)printerProps).put("service.description", "Sling Log Configuration Printer");
        ((Dictionary)printerProps).put("felix.webconsole.label", "leakdetector");
        ((Dictionary)printerProps).put("felix.webconsole.title", "Classloader Leak Detector");
        ((Dictionary)printerProps).put("felix.webconsole.configprinter.modes", "always");
        context.registerService(LeakDetector.class.getName(), (Object)this, printerProps);
    }

    public void stop(BundleContext context) {
        this.bundleTracker.close();
        this.referencePoller.interrupt();
    }

    private void registerBundle(Bundle bundle) {
        ClassLoader cl = LeakDetector.getClassloader(bundle);
        if (cl != null) {
            BundleReference ref = new BundleReference(bundle, cl);
            this.refs.add(ref);
            BundleInfo bi = (BundleInfo)this.bundleInfos.get(bundle.getBundleId());
            if (bi == null) {
                bi = new BundleInfo(bundle);
                this.bundleInfos.put(bundle.getBundleId(), bi);
            }
            bi.incrementUsageCount(ref);
            this.log.info("Registered bundle [{}] with Classloader [{}]", (Object)bi, (Object)ref.classloaderInfo);
        }
    }

    public void run() {
        BundleReference ref;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ref = (BundleReference)this.queue.remove();
                if (ref == null) continue;
                this.removeBundle(ref);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        this.log.info("Shutting down reference collector for Classloader LeakDetector");
        ref = null;
        while ((ref = (BundleReference)this.queue.poll()) != null) {
            this.removeBundle(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBundle(BundleReference ref) {
        BundleInfo bi = (BundleInfo)this.bundleInfos.get(ref.bundleId);
        Object object = this.leakDetectorLock;
        synchronized (object) {
            bi.decrementUsageCount(ref);
            this.refs.remove(ref);
            ref.clear();
        }
        this.log.info("Detected garbage collection of bundle [{}] - Classloader [{}]", (Object)bi, (Object)ref.classloaderInfo);
    }

    public void printConfiguration(PrintWriter pw) {
        HashSet<Long> activeBundleIds = new HashSet<Long>();
        for (Bundle b : this.context.getBundles()) {
            activeBundleIds.add(b.getBundleId());
        }
        ArrayList suspiciousBundles = new ArrayList(this.bundleInfos.values());
        Iterator itr = suspiciousBundles.iterator();
        while (itr.hasNext()) {
            BundleInfo bi = (BundleInfo)itr.next();
            if (!bi.hasSingleInstance() || !activeBundleIds.contains(bi.bundleId)) continue;
            itr.remove();
        }
        if (suspiciousBundles.isEmpty()) {
            pw.println("No classloader leak detected");
        } else {
            pw.println("Possible classloader leak detected");
            pw.printf("Number of suspicious bundles - %d %n", suspiciousBundles.size());
            pw.println();
            String tab = "    ";
            for (BundleInfo bi : suspiciousBundles) {
                pw.printf("* %s %n", bi);
                pw.printf("%s - Bundle Id - %d %n", "    ", bi.bundleId);
                pw.printf("%s - Leaked classloaders %n", "    ");
                for (ClassloaderInfo ci : bi.leakedClassloaders()) {
                    pw.printf("%s%s - %s %n", "    ", "    ", ci);
                }
            }
        }
        pw.println();
        LeakDetector.addHelp(pw);
    }

    private static void addHelp(PrintWriter pw) {
        boolean containsRequiredArgs;
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        List<String> argList = bean.getInputArguments();
        boolean bl = containsRequiredArgs = argList.contains("-XX:+UseConcMarkSweepGC") && argList.contains("-XX:+CMSClassUnloadingEnabled");
        if (!containsRequiredArgs) {
            pw.println("Required VM Options Missing");
            pw.println("===========================");
            pw.println("Leak detector relies on garbage collection of classloaders. By default");
            pw.println("the classloaders are not garbage collected. To enable garbage collection of");
            pw.println("classloader start the JVM with following options ");
            pw.println("");
            pw.println("    -XX:+UseConcMarkSweepGC -XX:+CMSClassUnloadingEnabled");
        }
    }

    private static ClassLoader getClassloader(Bundle b) {
        BundleWiring bw = (BundleWiring)b.adapt(BundleWiring.class);
        if (bw != null) {
            return bw.getClassLoader();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleReference
    extends PhantomReference<ClassLoader> {
        final Long bundleId;
        final ClassloaderInfo classloaderInfo;

        public BundleReference(Bundle bundle, ClassLoader cl) {
            super(cl, LeakDetector.this.queue);
            this.bundleId = bundle.getBundleId();
            this.classloaderInfo = new ClassloaderInfo(cl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassloaderInfo
    implements Comparable<ClassloaderInfo> {
        final Long creationTime = System.currentTimeMillis();
        final long systemHashCode;

        private ClassloaderInfo(ClassLoader cl) {
            this.systemHashCode = System.identityHashCode(cl);
        }

        @Override
        public int compareTo(ClassloaderInfo o) {
            return this.creationTime.compareTo(o.creationTime);
        }

        public String getAddress() {
            return Long.toHexString(this.systemHashCode);
        }

        public String getCreationDate() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
            return dateFormat.format(new Date(this.creationTime));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassloaderInfo that = (ClassloaderInfo)o;
            return this.systemHashCode == that.systemHashCode;
        }

        public int hashCode() {
            return (int)(this.systemHashCode ^ this.systemHashCode >>> 32);
        }

        public String toString() {
            return String.format("Identity HashCode - %s, Creation time %s", this.getAddress(), this.getCreationDate());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BundleInfo {
        final String symbolicName;
        final String version;
        final long bundleId;
        private final Set<ClassloaderInfo> classloaderInfos = Collections.synchronizedSet(new HashSet());

        public BundleInfo(Bundle b) {
            this.symbolicName = b.getSymbolicName();
            this.version = b.getVersion().toString();
            this.bundleId = b.getBundleId();
        }

        public synchronized void incrementUsageCount(BundleReference ref) {
            this.classloaderInfos.add(ref.classloaderInfo);
        }

        public synchronized void decrementUsageCount(BundleReference ref) {
            this.classloaderInfos.remove(ref.classloaderInfo);
        }

        public synchronized boolean hasSingleInstance() {
            return this.classloaderInfos.size() == 1;
        }

        public synchronized List<ClassloaderInfo> leakedClassloaders() {
            if (this.hasSingleInstance()) {
                return new ArrayList<ClassloaderInfo>(this.classloaderInfos);
            }
            ArrayList<ClassloaderInfo> cis = new ArrayList<ClassloaderInfo>(this.classloaderInfos);
            Collections.sort(cis);
            return cis.subList(0, cis.size() - 1);
        }

        public String toString() {
            return String.format("%s (%s) - Classloader Count [%s]", this.symbolicName, this.version, this.classloaderInfos.size());
        }
    }

    private class LeakDetectorBundleTracker
    extends BundleTracker {
        public LeakDetectorBundleTracker(BundleContext context) {
            super(context, 32, null);
            this.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingBundle(Bundle bundle, BundleEvent event) {
            Object object = LeakDetector.this.leakDetectorLock;
            synchronized (object) {
                LeakDetector.this.registerBundle(bundle);
            }
            return bundle;
        }
    }
}

