/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.transport.impl;

import java.net.URI;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.sling.distribution.monitor.impl.UserCredentialsDistributionTransportSecretMBean;
import org.apache.sling.distribution.monitor.impl.UserCredentialsDistributionTransportSecretMBeanImpl;
import org.apache.sling.distribution.transport.DistributionTransportSecret;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionTransportSecretProvider.class}, property={"webconsole.configurationFactory.nameHint=Secret provider name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class UserCredentialsDistributionTransportSecretProvider
implements DistributionTransportSecretProvider {
    private String username;
    private String password;
    private ServiceRegistration<UserCredentialsDistributionTransportSecretMBean> mbeanServiceRegistration;

    @Activate
    protected void activate(BundleContext context, Config conf) {
        this.username = conf.username().trim();
        this.password = conf.password().trim();
        String id = String.valueOf(this.username.hashCode());
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
        ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling.distribution:type=transport,id=" + ObjectName.quote(id));
        UserCredentialsDistributionTransportSecretMBeanImpl mbean = new UserCredentialsDistributionTransportSecretMBeanImpl(this.username);
        this.mbeanServiceRegistration = context.registerService(UserCredentialsDistributionTransportSecretMBean.class, (Object)mbean, mbeanProps);
    }

    @Deactivate
    protected void deactivate() {
        if (this.mbeanServiceRegistration != null) {
            this.mbeanServiceRegistration.unregister();
        }
        this.mbeanServiceRegistration = null;
    }

    public DistributionTransportSecret getSecret(URI uri) {
        return new DistributionTransportSecret(){

            public Map<String, String> asCredentialsMap() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("username", UserCredentialsDistributionTransportSecretProvider.this.username);
                map.put("password", UserCredentialsDistributionTransportSecretProvider.this.password);
                return Collections.unmodifiableMap(map);
            }
        };
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Transport Credentials - User Credentials based DistributionTransportSecretProvider")
    public static @interface Config {
        @AttributeDefinition(name="Name")
        public String name();

        @AttributeDefinition(name="User Name", description="The name of the user used to perform remote actions.")
        public String username();

        @AttributeDefinition(type=AttributeType.PASSWORD, name="Password", description="The clear text password to perform authentication. Warning: storing clear text passwords is not safe.")
        public String password();
    }
}

