/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencePackage
extends AbstractDistributionPackage {
    static final String REFERENCE_PREFIX = "reference-";
    private final DistributionPackage distributionPackage;
    private final String reference;

    public ReferencePackage(DistributionPackage distributionPackage) {
        super(REFERENCE_PREFIX + distributionPackage.getId(), distributionPackage.getType(), null, null);
        this.distributionPackage = distributionPackage;
        this.reference = REFERENCE_PREFIX + distributionPackage.getId();
        this.getInfo().putAll((Map)((Object)distributionPackage.getInfo()));
        this.getInfo().put("isReference", true);
    }

    @Override
    public void acquire(String ... holderNames) {
        if (this.distributionPackage instanceof AbstractDistributionPackage) {
            ((AbstractDistributionPackage)this.distributionPackage).acquire(holderNames);
        }
    }

    @Override
    public void release(String ... holderNames) {
        if (this.distributionPackage instanceof AbstractDistributionPackage) {
            ((AbstractDistributionPackage)this.distributionPackage).release(holderNames);
        }
    }

    @Override
    @NotNull
    public InputStream createInputStream() throws IOException {
        return new ByteArrayInputStream(this.reference.getBytes());
    }

    @Override
    public long getSize() {
        return this.getId().length();
    }

    @Override
    public void close() {
        this.distributionPackage.close();
    }

    @Override
    public void delete() {
        this.distributionPackage.delete();
    }

    @Override
    @NotNull
    public String getType() {
        return this.getInfo().getType();
    }

    @Override
    @NotNull
    public String getId() {
        return this.reference;
    }

    @Override
    @Nullable
    public String getDigestAlgorithm() {
        if (this.distributionPackage instanceof AbstractDistributionPackage) {
            ((AbstractDistributionPackage)this.distributionPackage).getDigestAlgorithm();
        }
        return null;
    }

    @Override
    public String getDigestMessage() {
        if (this.distributionPackage instanceof AbstractDistributionPackage) {
            ((AbstractDistributionPackage)this.distributionPackage).getDigestMessage();
        }
        return null;
    }

    public static boolean isReference(String string) {
        return string.startsWith(REFERENCE_PREFIX);
    }

    @Nullable
    public static String idFromReference(String reference) {
        return ReferencePackage.isReference(reference) ? reference.substring(REFERENCE_PREFIX.length()) : null;
    }
}

