/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.trigger.DistributionTrigger;

public enum DistributionComponentKind {
    AGENT("agent", "sling/distribution/service/agent", "sling/distribution/service/agent/list", DistributionAgent.class),
    IMPORTER("importer", "sling/distribution/service/importer", "sling/distribution/service/importer/list", DistributionPackageImporter.class),
    EXPORTER("exporter", "sling/distribution/service/exporter", "sling/distribution/service/exporter/list", DistributionPackageExporter.class),
    QUEUE_PROVIDER("queueProvider", "sling/distribution/service", "sling/distribution/service", DistributionQueueProvider.class),
    QUEUE_STRATEGY("queueStrategy", "sling/distribution/service", "sling/distribution/service", DistributionQueueDispatchingStrategy.class),
    TRANSPORT_SECRET_PROVIDER("transportSecretProvider", "sling/distribution/service", "sling/distribution/service", DistributionTransportSecretProvider.class),
    PACKAGE_BUILDER("packageBuilder", "sling/distribution/service", "sling/distribution/service", DistributionPackageBuilder.class),
    REQUEST_AUTHORIZATION("requestAuthorization", "sling/distribution/service", "sling/distribution/service", DistributionRequestAuthorizationStrategy.class),
    TRIGGER("trigger", "sling/distribution/service/trigger", "sling/distribution/service/trigger/list", DistributionTrigger.class);

    private final String name;
    private final String resourceType;
    private final String rootResourceType;
    private final Class<?> type;

    private DistributionComponentKind(String name, String resourceType, String rootResourceType, Class<?> type) {
        this.name = name;
        this.resourceType = resourceType;
        this.rootResourceType = rootResourceType;
        this.type = type;
    }

    public Class<?> asClass() {
        return this.type;
    }

    public static DistributionComponentKind fromClass(Class<?> type) {
        for (DistributionComponentKind kind : DistributionComponentKind.values()) {
            Class<?> kindClass = kind.asClass();
            if (!kindClass.equals(type)) continue;
            return kind;
        }
        return null;
    }

    public static DistributionComponentKind fromName(String name) {
        for (DistributionComponentKind kind : DistributionComponentKind.values()) {
            if (!kind.getName().equals(name)) continue;
            return kind;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getRootResourceType() {
        return this.rootResourceType;
    }
}

