/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.core.internal.CommonUtils;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=bulkreplace"})
public class BulkReplaceOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(BulkReplaceOperation.class);
    public static final String PN_UPDATE_PROPERTIES = "updateProperties";
    public static final String MODE_REGEX = "regex";
    public static final String PN_FIND = "find";
    public static final String PN_REPLACE = "replace";
    public static final String PN_MODE = "mode";

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        try {
            String path = request.getResource().getPath();
            response.setPath(path);
            Pattern updateProperties = Pattern.compile(request.getParameter(PN_UPDATE_PROPERTIES));
            if (log.isDebugEnabled()) {
                log.debug("Updating properties matching: {}", (Object)updateProperties.pattern());
            }
            Pattern rfind = null;
            String find = request.getParameter(PN_FIND);
            if (MODE_REGEX.equals(request.getParameter(PN_MODE))) {
                if (log.isDebugEnabled()) {
                    log.debug("Using regular expressions to search for {}", (Object)CommonUtils.escapeLogMessage(find));
                }
                rfind = Pattern.compile(find);
            } else if (log.isDebugEnabled()) {
                log.debug("Searching for {}", (Object)CommonUtils.escapeLogMessage(find));
            }
            String replace = request.getParameter(PN_REPLACE);
            if (log.isDebugEnabled()) {
                log.debug("Replacing with {}", (Object)CommonUtils.escapeLogMessage(replace));
            }
            ArrayList<Modification> changes = new ArrayList<Modification>();
            this.updateProperties(request.getResource(), updateProperties, rfind, find, replace, response, changes);
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            HashMap<String, String> modificationSourcesContainingPostfix = new HashMap<String, String>();
            HashSet<String> allModificationSources = new HashSet<String>(changes.size());
            for (Modification modification : changes) {
                String source = modification.getSource();
                if (source == null) continue;
                allModificationSources.add(source);
                int atIndex = source.indexOf(64);
                if (atIndex <= 0) continue;
                modificationSourcesContainingPostfix.put(source.substring(0, atIndex), source);
            }
            request.getResourceResolver().commit();
        }
        catch (Exception e) {
            log.error("Exception during response processing.", (Throwable)e);
            response.setError((Throwable)e);
        }
    }

    private void updateProperties(Resource resource, Pattern updateProperties, Pattern rfind, String find, String replace, PostResponse response, List<Modification> changes) {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        boolean updated = false;
        if (properties == null) {
            throw new SlingException("Failed to retrieve modifiable value map, cannot update properties", null);
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (!updateProperties.matcher((CharSequence)entry.getKey()).matches()) continue;
            updated = this.updateProperty(resource, rfind, find, replace, properties, updated, entry);
        }
        if (updated) {
            response.onModified(resource.getPath());
            changes.add(Modification.onModified((String)resource.getPath()));
        }
        for (Resource child : resource.getChildren()) {
            this.updateProperties(child, updateProperties, rfind, find, replace, response, changes);
        }
    }

    private boolean updateProperty(Resource resource, Pattern rfind, String find, String replace, ModifiableValueMap properties, boolean updated, Map.Entry<String, Object> entry) {
        log.trace("Checking property {}@{}", (Object)resource.getPath(), (Object)entry.getKey());
        if (properties.get((Object)entry.getKey()) instanceof String) {
            Matcher m;
            String value = (String)entry.getValue();
            if (rfind == null && (value.contains(find) || value.equals(find))) {
                value = value.replace(find, replace);
                log.trace("Value after replacement: {}", (Object)value);
                properties.put((Object)entry.getKey(), (Object)value);
                updated = true;
            } else if (rfind != null && (m = rfind.matcher(value)).find()) {
                value = rfind.matcher(value).replaceAll(replace);
                log.trace("Value after replacement: {}", (Object)value);
                properties.put((Object)entry.getKey(), (Object)value);
                updated = true;
            }
        } else if (properties.get((Object)entry.getKey()) instanceof String[]) {
            log.trace("Found array value");
            boolean arrUpdated = false;
            Object[] v = (String[])entry.getValue();
            for (int i = 0; i < v.length; ++i) {
                Matcher m;
                String value = v[i];
                if (rfind == null && (value.contains(find) || value.equals(find))) {
                    v[i] = value.replace(find, replace);
                    arrUpdated = true;
                    continue;
                }
                if (rfind == null || !(m = rfind.matcher(value)).find()) continue;
                v[i] = rfind.matcher(value).replaceAll(replace);
                arrUpdated = true;
            }
            if (arrUpdated) {
                if (log.isTraceEnabled()) {
                    log.trace("Value after replacement: {}", (Object)Arrays.toString(v));
                }
                properties.put((Object)entry.getKey(), (Object)v);
                updated = true;
            }
        }
        return updated;
    }
}

