/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.ide.impl.vlt.JcrCommand;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.ResourceProxy;

public class ReorderChildNodesCommand
extends JcrCommand<Void> {
    private final ResourceProxy resource;

    public ReorderChildNodesCommand(Repository repository, Credentials credentials, ResourceProxy resource, Logger logger) {
        super(repository, credentials, resource.getPath(), logger, new Repository.CommandExecutionFlag[0]);
        this.resource = resource;
    }

    @Override
    protected Void execute0(Session session) throws RepositoryException, IOException {
        boolean nodeExists = session.nodeExists(this.getPath().asString());
        if (!nodeExists) {
            return null;
        }
        Node node = session.getNode(this.getPath().asString());
        NodeType primaryNodeType = node.getPrimaryNodeType();
        if (primaryNodeType.hasOrderableChildNodes()) {
            this.reorderChildNodes(node, this.resource);
        }
        return null;
    }

    private void reorderChildNodes(Node nodeToReorder, ResourceProxy resourceToReorder) throws RepositoryException {
        List children = resourceToReorder.getChildren();
        ListIterator childrenIterator = children.listIterator();
        if (!childrenIterator.hasNext()) {
            this.getLogger().trace("Resource at {0} has no children, skipping child node reordering", new Object[]{resourceToReorder.getPath()});
            return;
        }
        HashSet<String> resourceChildNames = new HashSet<String>(children.size());
        HashSet<String> nodeChildNames = new HashSet<String>(children.size());
        LinkedList<Node> nodeChildren = new LinkedList<Node>();
        NodeIterator nodeChildrenIt = nodeToReorder.getNodes();
        while (nodeChildrenIt.hasNext()) {
            Node node = nodeChildrenIt.nextNode();
            nodeChildren.add(node);
            nodeChildNames.add(node.getName());
        }
        for (ResourceProxy childResources : children) {
            resourceChildNames.add(childResources.getPath().getName());
        }
        ListIterator nodeChildrenListIt = nodeChildren.listIterator();
        this.traceResourcesAndNodes(children, nodeChildren);
        if (!resourceChildNames.equals(nodeChildNames)) {
            this.getLogger().warn("Different child names between the local workspace ( " + String.valueOf(resourceChildNames) + ") and the repository (" + String.valueOf(nodeChildNames) + ") for path " + String.valueOf(this.resource.getPath()) + ". Reordering will not be performed");
            return;
        }
        while (childrenIterator.hasNext() || nodeChildrenListIt.hasNext()) {
            String expectedParentName;
            ResourceProxy childResource = (ResourceProxy)childrenIterator.next();
            Node childNode = (Node)nodeChildrenListIt.next();
            if (childResource.getPath().getName().equals(childNode.getName())) {
                if (!resourceToReorder.covers(childResource.getPath())) continue;
                this.reorderChildNodes(childNode, childResource);
                continue;
            }
            if (!nodeToReorder.getPrimaryNodeType().hasOrderableChildNodes()) {
                this.getLogger().trace("Node at {0} does not have orderable child nodes, skipping reordering of {1}", new Object[]{nodeToReorder.getPath(), childResource.getPath()});
                continue;
            }
            if (childrenIterator.hasNext()) {
                expectedParentName = ((ResourceProxy)childrenIterator.next()).getPath().getName();
                childrenIterator.previous();
            } else {
                expectedParentName = null;
            }
            this.getLogger().trace("For node at {0} ordering {1} before {2}", new Object[]{nodeToReorder.getPath(), childResource.getPath().getName(), expectedParentName});
            nodeToReorder.orderBefore(childResource.getPath().getName(), expectedParentName);
        }
    }

    private void traceResourcesAndNodes(List<ResourceProxy> children, List<Node> nodeChildren) throws RepositoryException {
        int i;
        StringBuilder out = new StringBuilder();
        out.append("Comparison of nodes and resources before reordering \n");
        out.append(" === Resources === \n");
        for (i = 0; i < children.size(); ++i) {
            out.append(String.format("%3d. %s%n", i, children.get(i).getPath()));
        }
        out.append(" === Nodes === \n");
        for (i = 0; i < nodeChildren.size(); ++i) {
            out.append(String.format("%3d. %s%n", i, nodeChildren.get(i).getPath()));
        }
        this.getLogger().trace(out.toString(), new Object[0]);
    }

    @Override
    public Command.Kind getKind() {
        return Command.Kind.REORDER_CHILDREN;
    }
}

