/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.producer;

import io.swagger.converter.ModelConverters;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapperConfig;
import org.apache.servicecomb.swagger.invocation.arguments.ProviderParameter;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerSpringMVCQueryObjectMapper;
import org.springframework.stereotype.Component;

@Component
public class SpringMVCProducerArgumentsMapperFactory
extends ProducerArgumentsMapperFactory {
    @Override
    public boolean canProcess(ArgumentsMapperConfig config) {
        return config.getSwaggerGeneratorContext().getClass().getCanonicalName().equals("org.apache.servicecomb.swagger.generator.springmvc.SpringmvcSwaggerGeneratorContext");
    }

    @Override
    protected Set<String> findAggregatedParamNames(Map<String, ProviderParameter> providerParamMap, Map<String, ProducerArgumentsMapperFactory.ParamWrapper<Parameter>> swaggerParamMap) {
        HashSet<String> queryObjectSet = new HashSet<String>();
        for (Map.Entry<String, ProviderParameter> entry : providerParamMap.entrySet()) {
            Type paramType = entry.getValue().getType();
            Property property = ModelConverters.getInstance().readAsProperty(paramType);
            if (!RefProperty.class.isInstance(property)) continue;
            queryObjectSet.add(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : swaggerParamMap.entrySet()) {
            if (!ParamUtils.isRealBodyParameter((Parameter)((Parameter)((ProducerArgumentsMapperFactory.ParamWrapper)entry.getValue()).getParam()))) continue;
            queryObjectSet.remove(entry.getKey());
        }
        return queryObjectSet;
    }

    @Override
    protected void generateAggregatedParamMapper(ArgumentsMapperConfig config, Map<String, ProviderParameter> providerParamMap, Map<String, ProducerArgumentsMapperFactory.ParamWrapper<Parameter>> swaggerParamMap, Set<String> aggregatedParamNames) {
        HashMap<String, Integer> querySwaggerParamsIndex = new HashMap<String, Integer>();
        for (Map.Entry<String, ProducerArgumentsMapperFactory.ParamWrapper<Parameter>> wrapperEntry : swaggerParamMap.entrySet()) {
            if (!(wrapperEntry.getValue().getParam() instanceof QueryParameter)) continue;
            querySwaggerParamsIndex.put(wrapperEntry.getKey(), wrapperEntry.getValue().getIndex());
        }
        for (String queryObjectName : aggregatedParamNames) {
            ProviderParameter providerParameter = providerParamMap.get(queryObjectName);
            ProducerSpringMVCQueryObjectMapper mapper = new ProducerSpringMVCQueryObjectMapper(querySwaggerParamsIndex, providerParameter.getIndex(), providerParameter.getType());
            config.addArgumentMapper(mapper);
        }
    }
}

