/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.validation;

import java.util.List;
import org.openapitools.codegen.validation.Validated;
import org.openapitools.codegen.validation.ValidationResult;
import org.openapitools.codegen.validation.ValidationRule;
import org.openapitools.codegen.validation.Validator;

public class GenericValidator<TInput>
implements Validator<TInput> {
    private List<ValidationRule> rules;

    public GenericValidator(List<ValidationRule> rules) {
        this.rules = rules;
    }

    @Override
    public ValidationResult validate(TInput input) {
        ValidationResult result = new ValidationResult();
        if (this.rules != null) {
            this.rules.forEach(it -> {
                boolean passes = it.evaluate(input);
                if (passes) {
                    result.addResult(Validated.valid(it));
                } else {
                    result.addResult(Validated.invalid(it, it.getFailureMessage()));
                }
            });
        }
        return result;
    }
}

