/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest;

import io.vertx.core.json.Json;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.RestVertxProducerInvocationCreator;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestProducerInvocationCreator
implements InvocationCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestVertxProducerInvocationCreator.class);
    protected MicroserviceMeta microserviceMeta;
    protected final Endpoint endpoint;
    protected final HttpServletRequestEx requestEx;
    protected final HttpServletResponseEx responseEx;
    protected RestOperationMeta restOperationMeta;
    protected ProduceProcessor produceProcessor;

    public RestProducerInvocationCreator(MicroserviceMeta microserviceMeta, Endpoint endpoint, HttpServletRequestEx requestEx, HttpServletResponseEx responseEx) {
        this.microserviceMeta = microserviceMeta;
        this.endpoint = endpoint;
        this.requestEx = requestEx;
        this.responseEx = responseEx;
    }

    public CompletableFuture<Invocation> createAsync() {
        this.initRestOperation();
        Invocation invocation = this.createInstance();
        this.initInvocationContext(invocation);
        this.addParameterContext(invocation);
        this.initTransportContext(invocation);
        invocation.addLocalContext("servicecomb-rest-request", (Object)this.requestEx);
        return CompletableFuture.completedFuture(invocation);
    }

    protected Invocation createInstance() {
        return InvocationFactory.forProvider((Endpoint)this.endpoint, (OperationMeta)this.restOperationMeta.getOperationMeta(), null);
    }

    protected void initInvocationContext(Invocation invocation) {
        if (!LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.context.decodeInvocationContext", (boolean)true)) {
            return;
        }
        String strCseContext = this.requestEx.getHeader("x-cse-context");
        if (StringUtils.isEmpty((CharSequence)strCseContext)) {
            return;
        }
        Map invocationContext = (Map)Json.decodeValue((String)strCseContext, Map.class);
        invocation.mergeContext(invocationContext);
    }

    protected void addParameterContext(Invocation invocation) {
        String headerContextMapper = LegacyPropertyFactory.getStringProperty((String)"servicecomb.context.headerContextMapper");
        String queryContextMapper = LegacyPropertyFactory.getStringProperty((String)"servicecomb.context.queryContextMapper");
        HashMap<String, Object> headerContextMappers = headerContextMapper != null ? YAMLUtil.yaml2Properties((String)headerContextMapper) : new HashMap<String, Object>();
        HashMap<String, Object> queryContextMappers = queryContextMapper != null ? YAMLUtil.yaml2Properties((String)queryContextMapper) : new HashMap<String, Object>();
        headerContextMappers.forEach((k, v) -> {
            if (v instanceof String && this.requestEx.getHeader(k) != null) {
                invocation.addContext((String)v, this.requestEx.getHeader(k));
            }
        });
        queryContextMappers.forEach((k, v) -> {
            if (v instanceof String && this.requestEx.getParameter(k) != null) {
                invocation.addContext((String)v, this.requestEx.getParameter(k));
            }
        });
    }

    protected abstract void initTransportContext(Invocation var1);

    protected void initRestOperation() {
        OperationLocator locator = this.locateOperation(this.microserviceMeta);
        this.requestEx.setAttribute("servicecomb-paths", locator.getPathVarMap());
        this.restOperationMeta = locator.getOperation();
    }

    protected OperationLocator locateOperation(MicroserviceMeta microserviceMeta) {
        ServicePathManager servicePathManager = ServicePathManager.getServicePathManager(microserviceMeta);
        if (servicePathManager == null) {
            LOGGER.error("No schema defined for {}:{}.", (Object)this.microserviceMeta.getAppId(), (Object)this.microserviceMeta.getMicroserviceName());
            throw Exceptions.create((Response.StatusType)Response.Status.NOT_FOUND, (String)"SCB.00000002", (String)Response.Status.NOT_FOUND.getReasonPhrase());
        }
        return this.locateOperation(servicePathManager);
    }

    protected OperationLocator locateOperation(ServicePathManager servicePathManager) {
        return servicePathManager.producerLocateOperation(this.requestEx.getRequestURI(), this.requestEx.getMethod());
    }
}

