/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.pojo.extend.parameter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;

public class PendingBodyParameter
extends BodyParameter {
    @JsonIgnore
    private OperationGenerator operationGenerator;
    @JsonIgnore
    private Property property;
    @JsonIgnore
    private Type type;

    public void setOperationGenerator(OperationGenerator operationGenerator) {
        this.operationGenerator = operationGenerator;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @JsonIgnore
    public Method getMethod() {
        return this.operationGenerator.getProviderMethod();
    }

    public BodyParameter createBodyParameter(String paramName) {
        String modelType = ParamUtils.generateBodyParameterName(this.operationGenerator.getProviderMethod());
        RefModel model = this.toRefModel(modelType);
        this.setName(paramName);
        this.setSchema((Model)model);
        try {
            return (BodyParameter)Json.mapper().readValue(Json.mapper().writeValueAsString((Object)this), BodyParameter.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to createBodyParameter.", e);
        }
    }

    private RefModel toRefModel(String modelType) {
        if (RefProperty.class.isInstance(this.property)) {
            return (RefModel)PropertyBuilder.toModel((Property)this.property);
        }
        ModelImpl modelImpl = new ModelImpl();
        modelImpl.setType("object");
        modelImpl.setName(this.name);
        modelImpl.addProperty(this.name, this.property);
        this.operationGenerator.getSwagger().addDefinition(modelType, (Model)modelImpl);
        RefModel refModel = new RefModel();
        refModel.setReference("#/definitions/" + modelType);
        return refModel;
    }
}

