/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.executor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.executor.ThreadPoolExecutorEx;

public class LinkedBlockingQueueEx<E>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = -1L;
    private static final int COUNT_BITS = 29;
    private static final int CAPACITY = 0x1FFFFFFF;
    private static Method addWrokerMethod;
    private volatile transient ThreadPoolExecutorEx owner = null;
    private AtomicInteger ctl;

    private static int workerCountOf(int c) {
        return c & 0x1FFFFFFF;
    }

    public LinkedBlockingQueueEx(int capacity) {
        super(capacity);
    }

    public void setOwner(ThreadPoolExecutorEx owner) {
        this.owner = owner;
        try {
            addWrokerMethod = ThreadPoolExecutor.class.getDeclaredMethod("addWorker", Runnable.class, Boolean.TYPE);
            addWrokerMethod.setAccessible(true);
            Field field = ThreadPoolExecutor.class.getDeclaredField("ctl");
            field.setAccessible(true);
            this.ctl = (AtomicInteger)field.get(owner);
        }
        catch (Throwable e) {
            throw new IllegalStateException("failed to init queue.", e);
        }
    }

    @Override
    public boolean offer(E runnable) {
        if (this.owner == null) {
            return super.offer(runnable);
        }
        if (LinkedBlockingQueueEx.workerCountOf(this.ctl.get()) == this.owner.getMaximumPoolSize()) {
            return super.offer(runnable);
        }
        if (this.owner.getNotFinished() <= LinkedBlockingQueueEx.workerCountOf(this.ctl.get())) {
            return super.offer(runnable);
        }
        if (LinkedBlockingQueueEx.workerCountOf(this.ctl.get()) < this.owner.getMaximumPoolSize()) {
            try {
                if (!((Boolean)addWrokerMethod.invoke((Object)this.owner, runnable, false)).booleanValue()) {
                    return super.offer(runnable);
                }
                return true;
            }
            catch (Throwable e) {
                return super.offer(runnable);
            }
        }
        return super.offer(runnable);
    }
}

