/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api.serializer;

import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.edm.EdmProperty;

public final class PrimitiveSerializerOptions {
    private ContextURL contextURL;
    private Boolean isNullable;
    private Integer maxLength;
    private Integer precision;
    private Integer scale;
    private Boolean isUnicode;
    private String xml10InvalidCharReplacement;

    public ContextURL getContextURL() {
        return this.contextURL;
    }

    public Boolean isNullable() {
        return this.isNullable;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Boolean isUnicode() {
        return this.isUnicode;
    }

    public String xml10InvalidCharReplacement() {
        return this.xml10InvalidCharReplacement;
    }

    private PrimitiveSerializerOptions() {
    }

    public static Builder with() {
        return new Builder();
    }

    public static final class Builder {
        private PrimitiveSerializerOptions options = new PrimitiveSerializerOptions();

        private Builder() {
        }

        public Builder contextURL(ContextURL contextURL) {
            this.options.contextURL = contextURL;
            return this;
        }

        public Builder nullable(Boolean isNullable) {
            this.options.isNullable = isNullable;
            return this;
        }

        public Builder maxLength(Integer maxLength) {
            this.options.maxLength = maxLength;
            return this;
        }

        public Builder precision(Integer precision) {
            this.options.precision = precision;
            return this;
        }

        public Builder scale(Integer scale) {
            this.options.scale = scale;
            return this;
        }

        public Builder unicode(Boolean isUnicode) {
            this.options.isUnicode = isUnicode;
            return this;
        }

        public Builder facetsFrom(EdmProperty property) {
            this.options.isNullable = property.isNullable();
            this.options.maxLength = property.getMaxLength();
            this.options.precision = property.getPrecision();
            this.options.scale = property.getScale();
            this.options.isUnicode = property.isUnicode();
            return this;
        }

        public Builder xml10InvalidCharReplacement(String replacement) {
            this.options.xml10InvalidCharReplacement = replacement;
            return this;
        }

        public PrimitiveSerializerOptions build() {
            return this.options;
        }
    }
}

