/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InetAddressUtil {
    private static Logger logger = Logger.getLogger(InetAddressUtil.class.getName());
    public static Pattern IPV4_QUADS = Pattern.compile("([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})");

    private InetAddressUtil() {
    }

    public static InetAddress getIPHostAddress(String host) {
        InetAddress result = null;
        Matcher matcher = IPV4_QUADS.matcher(host);
        if (matcher == null || !matcher.matches()) {
            return result;
        }
        try {
            result = InetAddress.getByAddress(host, new byte[]{(byte)new Integer(matcher.group(1)).intValue(), (byte)new Integer(matcher.group(2)).intValue(), (byte)new Integer(matcher.group(3)).intValue(), (byte)new Integer(matcher.group(4)).intValue()});
        }
        catch (NumberFormatException e) {
            logger.warning(e.getMessage());
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
        }
        return result;
    }

    public static List<String> getAllLocalHostNames() {
        ArrayList<String> localNames = new ArrayList<String>();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException exception) {
            throw new RuntimeException(exception);
        }
        while (e.hasMoreElements()) {
            Enumeration<InetAddress> ee = e.nextElement().getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress ia = ee.nextElement();
                if (ia == null) continue;
                if (ia.getHostName() != null) {
                    localNames.add(ia.getCanonicalHostName());
                }
                if (ia.getHostAddress() == null) continue;
                localNames.add(ia.getHostAddress());
            }
        }
        String localhost = "localhost";
        if (!localNames.contains("localhost")) {
            localNames.add("localhost");
        }
        String localhostLocaldomain = "localhost.localdomain";
        if (!localNames.contains("localhost.localdomain")) {
            localNames.add("localhost.localdomain");
        }
        return localNames;
    }
}

