/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.json;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.archive.format.json.CrossProductOfLists;
import org.archive.format.json.JSONPathSpec;
import org.archive.format.json.JSONPathSpecFactory;
import org.json.JSONObject;

public class JSONView {
    private static final Logger LOG = Logger.getLogger(JSONView.class.getName());
    ArrayList<JSONPathSpec> pathSpecs;
    CrossProductOfLists<String> crosser;

    public JSONView(String ... pathSpecs) {
        this.pathSpecs = new ArrayList(pathSpecs.length);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(String.format("Creating JSONView with(%s)", StringUtils.join((Object[])pathSpecs, (String)",")));
        }
        for (String pathSpec : pathSpecs) {
            this.pathSpecs.add(JSONPathSpecFactory.get(pathSpec));
        }
        this.crosser = new CrossProductOfLists();
    }

    public List<List<String>> apply(JSONObject json) {
        ArrayList results = new ArrayList(this.pathSpecs.size());
        for (JSONPathSpec pathSpec : this.pathSpecs) {
            List<List<String>> result = pathSpec.extract(json);
            if (result == null) {
                result = new ArrayList<List<String>>();
            }
            results.add(result);
        }
        return this.crosser.crossProduct(results);
    }
}

