/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.publisher;

import java.lang.invoke.MethodHandles;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.publisher.NutchPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NutchPublishers
extends Configured
implements NutchPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NutchPublisher[] publishers;
    private Configuration conf;

    public NutchPublishers(Configuration conf) {
        this.conf = conf;
        this.publishers = (NutchPublisher[])PluginRepository.get(conf).getOrderedPlugins(NutchPublisher.class, NutchPublisher.X_POINT_ID, "publisher.order");
    }

    @Override
    public boolean setConfig(Configuration conf) {
        boolean success = false;
        try {
            for (int i = 0; i < this.publishers.length; ++i) {
                if (!(success |= this.publishers[i].setConfig(conf))) continue;
                LOG.info("Successfully loaded {} publisher", (Object)this.publishers[i].getClass().getName());
            }
        }
        catch (Exception e) {
            LOG.warn("Error while loading publishers : {}", (Object)e.getMessage());
        }
        if (!success) {
            LOG.warn("Could not load any publishers out of {} publishers", (Object)this.publishers.length);
        }
        return success;
    }

    @Override
    public void publish(Object event, Configuration conf) {
        for (int i = 0; i < this.publishers.length; ++i) {
            try {
                this.publishers[i].publish(event, conf);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Could not post event to {}", (Object)this.publishers[i].getClass().getName());
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration arg0) {
    }
}

