/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.nutch.indexer.IndexWriters;
import org.apache.nutch.indexer.NutchIndexAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerOutputFormat
extends FileOutputFormat<Text, NutchIndexAction> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public RecordWriter<Text, NutchIndexAction> getRecordWriter(TaskAttemptContext context) throws IOException {
        final Configuration conf = context.getConfiguration();
        final IndexWriters writers = IndexWriters.get(conf);
        String name = IndexerOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)"part", (String)"");
        writers.open(conf, name);
        LOG.info(writers.describe());
        return new RecordWriter<Text, NutchIndexAction>(){

            public void close(TaskAttemptContext context) throws IOException {
                boolean noCommit = conf.getBoolean("indexer.nocommit", false);
                if (!noCommit) {
                    writers.commit();
                }
                writers.close();
            }

            public void write(Text key, NutchIndexAction indexAction) throws IOException {
                if (indexAction.action == 0) {
                    writers.write(indexAction.doc);
                } else if (indexAction.action == 1) {
                    writers.delete(key.toString());
                }
            }
        };
    }
}

