/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.assignor.AbstractUniformAssignmentBuilder;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.assignor.SubscribedTopicDescriber;
import org.apache.kafka.server.common.TopicIdPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizedUniformAssignmentBuilder
extends AbstractUniformAssignmentBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizedUniformAssignmentBuilder.class);
    private final AssignmentSpec assignmentSpec;
    private final SubscribedTopicDescriber subscribedTopicDescriber;
    private final Set<Uuid> subscribedTopicIds;
    private final AbstractUniformAssignmentBuilder.RackInfo rackInfo;
    private int remainingMembersToGetAnExtraPartition;
    private Map<String, Integer> potentiallyUnfilledMembers;
    private Set<TopicIdPartition> unassignedPartitions;
    private final Map<String, MemberAssignment> targetAssignment;
    private final Map<TopicIdPartition, String> currentPartitionOwners;

    OptimizedUniformAssignmentBuilder(AssignmentSpec assignmentSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        this.assignmentSpec = assignmentSpec;
        this.subscribedTopicDescriber = subscribedTopicDescriber;
        this.subscribedTopicIds = new HashSet<Uuid>(assignmentSpec.members().values().iterator().next().subscribedTopicIds());
        this.rackInfo = new AbstractUniformAssignmentBuilder.RackInfo(assignmentSpec, subscribedTopicDescriber, this.subscribedTopicIds);
        this.potentiallyUnfilledMembers = new HashMap<String, Integer>();
        this.targetAssignment = new HashMap<String, MemberAssignment>();
        this.currentPartitionOwners = this.rackInfo.useRackStrategy ? new HashMap() : Collections.emptyMap();
    }

    @Override
    protected GroupAssignment buildAssignment() throws PartitionAssignorException {
        int totalPartitionsCount = 0;
        if (this.subscribedTopicIds.isEmpty()) {
            LOG.debug("The subscription list is empty, returning an empty assignment");
            return new GroupAssignment(Collections.emptyMap());
        }
        for (Uuid topicId : this.subscribedTopicIds) {
            int partitionCount = this.subscribedTopicDescriber.numPartitions(topicId);
            if (partitionCount == -1) {
                throw new PartitionAssignorException("Members are subscribed to topic " + topicId + " which doesn't exist in the topic metadata.");
            }
            totalPartitionsCount += partitionCount;
        }
        int numberOfMembers = this.assignmentSpec.members().size();
        int minQuota = totalPartitionsCount / numberOfMembers;
        this.remainingMembersToGetAnExtraPartition = totalPartitionsCount % numberOfMembers;
        this.assignmentSpec.members().keySet().forEach(memberId -> this.targetAssignment.put((String)memberId, new MemberAssignment(new HashMap<Uuid, Set<Integer>>())));
        this.unassignedPartitions = OptimizedUniformAssignmentBuilder.topicIdPartitions(this.subscribedTopicIds, this.subscribedTopicDescriber);
        this.potentiallyUnfilledMembers = this.assignStickyPartitions(minQuota);
        if (this.rackInfo.useRackStrategy) {
            this.rackAwarePartitionAssignment();
        }
        this.unassignedPartitionsRoundRobinAssignment();
        if (!this.unassignedPartitions.isEmpty()) {
            throw new PartitionAssignorException("Partitions were left unassigned");
        }
        return new GroupAssignment(this.targetAssignment);
    }

    private Map<String, Integer> assignStickyPartitions(int minQuota) {
        HashMap<String, Integer> potentiallyUnfilledMembers = new HashMap<String, Integer>();
        this.assignmentSpec.members().forEach((memberId, assignmentMemberSpec) -> {
            List<TopicIdPartition> validCurrentMemberAssignment = this.validCurrentMemberAssignment((String)memberId, assignmentMemberSpec.assignedPartitions());
            int currentAssignmentSize = validCurrentMemberAssignment.size();
            int remaining = minQuota - currentAssignmentSize;
            if (currentAssignmentSize > 0) {
                int retainedPartitionsCount = Math.min(currentAssignmentSize, minQuota);
                IntStream.range(0, retainedPartitionsCount).forEach(i -> {
                    TopicIdPartition topicIdPartition = (TopicIdPartition)validCurrentMemberAssignment.get(i);
                    OptimizedUniformAssignmentBuilder.addPartitionToAssignment(this.targetAssignment, memberId, topicIdPartition.topicId(), topicIdPartition.partitionId());
                    this.unassignedPartitions.remove(topicIdPartition);
                });
                if (remaining < 0 && this.remainingMembersToGetAnExtraPartition > 0) {
                    TopicIdPartition topicIdPartition = validCurrentMemberAssignment.get(retainedPartitionsCount);
                    OptimizedUniformAssignmentBuilder.addPartitionToAssignment(this.targetAssignment, memberId, topicIdPartition.topicId(), topicIdPartition.partitionId());
                    this.unassignedPartitions.remove(topicIdPartition);
                    --this.remainingMembersToGetAnExtraPartition;
                }
            }
            if (remaining >= 0) {
                potentiallyUnfilledMembers.put((String)memberId, remaining);
            }
        });
        return potentiallyUnfilledMembers;
    }

    private List<TopicIdPartition> validCurrentMemberAssignment(String memberId, Map<Uuid, Set<Integer>> currentMemberAssignment) {
        ArrayList<TopicIdPartition> validCurrentAssignmentList = new ArrayList<TopicIdPartition>();
        currentMemberAssignment.forEach((topicId, partitions) -> {
            if (this.subscribedTopicIds.contains(topicId)) {
                partitions.forEach(partition -> {
                    TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, partition.intValue());
                    if (this.rackInfo.useRackStrategy && this.rackInfo.racksMismatch(memberId, topicIdPartition)) {
                        this.currentPartitionOwners.put(topicIdPartition, memberId);
                    } else {
                        validCurrentAssignmentList.add(topicIdPartition);
                    }
                });
            } else {
                LOG.debug("The topic " + topicId + " is no longer present in the subscribed topics list");
            }
        });
        return validCurrentAssignmentList;
    }

    private void rackAwarePartitionAssignment() {
        List<TopicIdPartition> sortedPartitions = this.rackInfo.sortPartitionsByRackMembers(this.unassignedPartitions);
        sortedPartitions.forEach(partition -> {
            List<String> sortedMembersWithMatchingRack = this.rackInfo.getSortedMembersWithMatchingRack((TopicIdPartition)partition, this.targetAssignment);
            for (String memberId : sortedMembersWithMatchingRack) {
                if (!this.potentiallyUnfilledMembers.containsKey(memberId) || !this.maybeAssignPartitionToMember(memberId, (TopicIdPartition)partition)) continue;
                this.unassignedPartitions.remove(partition);
                break;
            }
        });
    }

    private void unassignedPartitionsRoundRobinAssignment() {
        LinkedList<String> roundRobinMembers = new LinkedList<String>(this.potentiallyUnfilledMembers.keySet());
        List sortedPartitionsList = this.unassignedPartitions.stream().sorted(Comparator.comparing(TopicIdPartition::topicId).thenComparing(TopicIdPartition::partitionId)).collect(Collectors.toList());
        for (TopicIdPartition topicIdPartition : sortedPartitionsList) {
            String currentOwner;
            boolean assigned = false;
            if (this.rackInfo.useRackStrategy && this.currentPartitionOwners.containsKey(topicIdPartition) && this.potentiallyUnfilledMembers.containsKey(currentOwner = this.currentPartitionOwners.get(topicIdPartition))) {
                assigned = this.maybeAssignPartitionToMember(currentOwner, topicIdPartition);
                if (!this.potentiallyUnfilledMembers.containsKey(currentOwner)) {
                    roundRobinMembers.remove(currentOwner);
                }
            }
            for (int i = 0; i < roundRobinMembers.size() && !assigned; ++i) {
                String memberId = (String)roundRobinMembers.poll();
                if (this.potentiallyUnfilledMembers.containsKey(memberId)) {
                    assigned = this.maybeAssignPartitionToMember(memberId, topicIdPartition);
                }
                if (!this.potentiallyUnfilledMembers.containsKey(memberId)) continue;
                roundRobinMembers.add(memberId);
            }
            if (!assigned) continue;
            this.unassignedPartitions.remove(topicIdPartition);
        }
    }

    private boolean maybeAssignPartitionToMember(String memberId, TopicIdPartition topicIdPartition) {
        int remaining = this.potentiallyUnfilledMembers.get(memberId);
        boolean shouldAssign = false;
        if (remaining > 0) {
            this.potentiallyUnfilledMembers.put(memberId, --remaining);
            shouldAssign = true;
            if (remaining == 0 && this.remainingMembersToGetAnExtraPartition == 0) {
                this.potentiallyUnfilledMembers.remove(memberId);
            }
        } else if (remaining == 0 && this.remainingMembersToGetAnExtraPartition > 0) {
            --this.remainingMembersToGetAnExtraPartition;
            this.potentiallyUnfilledMembers.remove(memberId);
            shouldAssign = true;
        }
        if (shouldAssign) {
            OptimizedUniformAssignmentBuilder.addPartitionToAssignment(this.targetAssignment, memberId, topicIdPartition.topicId(), topicIdPartition.partitionId());
            return true;
        }
        return false;
    }
}

