/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.reroute;

import java.io.IOException;
import org.opensearch.LegacyESVersion;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.routing.allocation.RoutingExplanations;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public class ClusterRerouteResponse
extends AcknowledgedResponse
implements ToXContentObject {
    private final ClusterState state;
    private final RoutingExplanations explanations;

    ClusterRerouteResponse(StreamInput in) throws IOException {
        super(in, in.getVersion().onOrAfter(LegacyESVersion.V_6_4_0));
        if (in.getVersion().onOrAfter(LegacyESVersion.V_6_4_0)) {
            this.state = ClusterState.readFrom(in, null);
            this.explanations = RoutingExplanations.readFrom(in);
        } else {
            this.state = ClusterState.readFrom(in, null);
            this.acknowledged = in.readBoolean();
            this.explanations = RoutingExplanations.readFrom(in);
        }
    }

    ClusterRerouteResponse(boolean acknowledged, ClusterState state, RoutingExplanations explanations) {
        super(acknowledged);
        this.state = state;
        this.explanations = explanations;
    }

    public ClusterState getState() {
        return this.state;
    }

    public RoutingExplanations getExplanations() {
        return this.explanations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(LegacyESVersion.V_6_4_0)) {
            super.writeTo(out);
            this.state.writeTo(out);
            RoutingExplanations.writeTo(this.explanations, out);
        } else {
            if (out.getVersion().onOrAfter(LegacyESVersion.V_6_3_0)) {
                this.state.writeTo(out);
            } else {
                ClusterModule.filterCustomsForPre63Clients(this.state).writeTo(out);
            }
            out.writeBoolean(this.acknowledged);
            RoutingExplanations.writeTo(this.explanations, out);
        }
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("state");
        this.state.toXContent(builder, params);
        builder.endObject();
        if (params.paramAsBoolean("explain", false)) {
            this.explanations.toXContent(builder, ToXContent.EMPTY_PARAMS);
        }
    }
}

