/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.extension;

import crawlercommons.sitemaps.extension.ExtensionMetadata;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LinkAttributes
extends ExtensionMetadata {
    public static final String HREF = "href";
    private static final String PARAMS_PREFIX = "params.%s";
    private URL href;
    private Map<String, String> params;

    public LinkAttributes() {
    }

    public LinkAttributes(URL href) {
        this.href = href;
    }

    public URL getHref() {
        return this.href;
    }

    public void setHref(URL href) {
        this.href = href;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Links href: ").append(this.href);
        if (this.params != null && !this.params.isEmpty()) {
            sb.append(", params: ");
            boolean first = true;
            for (Map.Entry<String, String> e : this.params.entrySet()) {
                if (!first) {
                    sb.append(',');
                }
                sb.append(e.getKey()).append(':').append(e.getValue());
                first = false;
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof LinkAttributes)) {
            return false;
        }
        LinkAttributes that = (LinkAttributes)other;
        return LinkAttributes.urlEquals(this.href, that.href) && Objects.equals(this.params, that.params);
    }

    @Override
    public Map<String, String[]> asMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (this.href != null) {
            map.put(HREF, new String[]{this.href.toString()});
        }
        if (this.params != null) {
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                map.put(String.format(Locale.ROOT, PARAMS_PREFIX, entry.getKey()), new String[]{entry.getValue()});
            }
        }
        return Collections.unmodifiableMap(map);
    }
}

