/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parsefilter.debug;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.parse.HTMLMetaTags;
import org.apache.nutch.parse.HtmlParseFilter;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseResult;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.util.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DocumentFragment;

public class DebugParseFilter
implements HtmlParseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Configuration conf;

    public ParseResult filter(Content content, ParseResult parseResult, HTMLMetaTags metaTags, DocumentFragment doc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DomUtil.saveDom((OutputStream)baos, (DocumentFragment)doc);
        Parse parse = parseResult.get(content.getUrl());
        String dom = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        LOG.debug(dom);
        parse.getData().getParseMeta().set("DOM", dom);
        return parseResult;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

