/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.transform;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class AbstractXmlTransform
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tomahawk.XmlTransform";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.tomahawk.Transform";
    private Object contentStream;
    private Object styleStream;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        URL url;
        ClassLoader loader;
        InputStream xmlStream = (InputStream)this.getContentStream();
        String xml = this.getContent();
        String xmlLocation = this.getContentLocation();
        InputStream xslStream = (InputStream)this.getStyleStream();
        String xsl = this.getStylesheet();
        String xslLocation = this.getStylesheetLocation();
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.getContent() == null && this.getContentLocation() == null && this.getContentStream() == null) {
            throw new NullPointerException("content/contentLocation/contentStream cannot all be null");
        }
        if (xmlLocation != null) {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = AbstractXmlTransform.class.getClassLoader();
            }
            url = loader.getResource(xmlLocation);
            xmlStream = new FileInputStream(new File(URI.create(url.toString())));
        }
        if (xslLocation != null) {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = AbstractXmlTransform.class.getClassLoader();
            }
            url = loader.getResource(xslLocation);
            xslStream = new FileInputStream(new File(URI.create(url.toString())));
        }
        if (xml != null) {
            xmlStream = new ByteArrayInputStream(xml.getBytes());
        }
        if (xsl != null) {
            xslStream = new ByteArrayInputStream(xsl.getBytes());
        }
        if (xmlStream != null && xslStream != null) {
            this.transformContent(xmlStream, xslStream);
        }
    }

    private void transformContent(InputStream content, InputStream stylesheet) throws IOException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(stylesheet));
            ResponseWriter responseWriter = FacesContext.getCurrentInstance().getResponseWriter();
            transformer.transform(new StreamSource(content), new StreamResult((Writer)responseWriter));
        }
        catch (TransformerException te) {
            throw new IOException("Error while transforming XML: " + te.getMessage());
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void encodeEnd(FacesContext context) throws IOException {
    }

    public abstract String getContent();

    public abstract String getContentLocation();

    public abstract String getStylesheet();

    public void setContentStream(Object contentStream) {
        this.contentStream = contentStream;
    }

    public Object getContentStream() {
        if (this.contentStream != null) {
            return this.contentStream;
        }
        ValueBinding vb = this.getValueBinding("contentStream");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public abstract String getStylesheetLocation();

    public void setStyleStream(Object styleStream) {
        this.styleStream = styleStream;
    }

    public Object getStyleStream() {
        if (this.styleStream != null) {
            return this.styleStream;
        }
        ValueBinding vb = this.getValueBinding("styleStream");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }
}

