/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import org.apache.myfaces.component.MethodBindingToMethodExpression;
import org.apache.myfaces.component.MethodExpressionToMethodBinding;
import org.apache.myfaces.custom.schedule.ScheduleMouseEvent;
import org.apache.myfaces.custom.schedule.UIScheduleBase;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;

public class UISchedule
extends UIScheduleBase
implements Serializable,
ActionSource2 {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.UISchedule";
    private static final long serialVersionUID = -8333458172939036755L;
    private MethodBinding _actionListener;
    private ScheduleActionListener _scheduleListener = new ScheduleActionListener();
    private ScheduleEntry _submittedEntry;
    private MethodExpression _actionExpression;
    private MethodExpression _mouseListenerExpression;

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        FacesContext context = this.getFacesContext();
        if (event instanceof ScheduleMouseEvent) {
            ScheduleMouseEvent mouseEvent = (ScheduleMouseEvent)event;
            MethodBinding mouseListener = this.getMouseListener();
            if (mouseListener != null) {
                mouseListener.invoke(context, new Object[]{mouseEvent});
            }
        }
        if (event.isAppropriateListener((FacesListener)this._scheduleListener)) {
            event.processListener((FacesListener)this._scheduleListener);
        }
        super.broadcast(event);
        if (event instanceof ActionEvent) {
            ActionListener defaultActionListener;
            MethodBinding actionListener = this.getActionListener();
            if (actionListener != null) {
                actionListener.invoke(context, new Object[]{event});
            }
            if ((defaultActionListener = context.getApplication().getActionListener()) != null) {
                defaultActionListener.processAction((ActionEvent)event);
            }
        }
    }

    protected ScheduleEntry findEntry(String id) {
        if (id == null) {
            return null;
        }
        Iterator dayIterator = this.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            Iterator iter = day.iterator();
            while (iter.hasNext()) {
                ScheduleEntry entry = (ScheduleEntry)iter.next();
                if (!id.equals(entry.getId())) continue;
                return entry;
            }
        }
        return null;
    }

    public void setAction(MethodBinding action) {
        if (action != null) {
            this.setActionExpression(new MethodBindingToMethodExpression(action));
        } else {
            this.setActionExpression(null);
        }
    }

    public MethodBinding getAction() {
        MethodExpression actionExpression = this.getActionExpression();
        if (actionExpression instanceof MethodBindingToMethodExpression) {
            return ((MethodBindingToMethodExpression)actionExpression).getMethodBinding();
        }
        if (actionExpression != null) {
            return new MethodExpressionToMethodBinding(actionExpression);
        }
        return null;
    }

    public MethodExpression getActionExpression() {
        if (this._actionExpression != null) {
            return this._actionExpression;
        }
        ValueExpression expression = this.getValueExpression("actionExpression");
        if (expression != null) {
            return (MethodExpression)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setActionExpression(MethodExpression actionExpression) {
        this._actionExpression = actionExpression;
        if (this.initialStateMarked()) {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.actionExpressionSet), (Object)Boolean.TRUE);
        }
    }

    private boolean _isSetActionExpression() {
        Boolean value = (Boolean)this.getStateHelper().get((Serializable)((Object)PropertyKeys.actionExpressionSet));
        return value == null ? false : value;
    }

    public MethodExpression getMouseListenerExpression() {
        if (this._mouseListenerExpression != null) {
            return this._mouseListenerExpression;
        }
        ValueExpression expression = this.getValueExpression("mouseListenerExpression");
        if (expression != null) {
            return (MethodExpression)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMouseListenerExpression(MethodExpression mouseListenerExpression) {
        this._mouseListenerExpression = mouseListenerExpression;
        if (this.initialStateMarked()) {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.mouseListenerExpressionSet), (Object)Boolean.TRUE);
        }
    }

    public MethodBinding getActionListener() {
        return this._actionListener;
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public Date getLastClickedDateAndTime() {
        return (Date)this.getStateHelper().get((Serializable)((Object)PropertyKeys.lastClickedDateAndTime));
    }

    public void setMouseListener(MethodBinding mouseListener) {
        if (mouseListener != null) {
            this.setMouseListenerExpression(new MethodBindingToMethodExpression(mouseListener));
        } else {
            this.setMouseListenerExpression(null);
        }
    }

    public MethodBinding getMouseListener() {
        MethodExpression mouseListenerExpression = this.getMouseListenerExpression();
        if (mouseListenerExpression instanceof MethodBindingToMethodExpression) {
            return ((MethodBindingToMethodExpression)mouseListenerExpression).getMethodBinding();
        }
        if (mouseListenerExpression != null) {
            return new MethodExpressionToMethodBinding(mouseListenerExpression);
        }
        return null;
    }

    public ScheduleEntry getSubmittedEntry() {
        return this._submittedEntry;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ActionEvent || event instanceof ScheduleMouseEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    protected void resetMouseEvents() {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lastClickedDateAndTime), null);
    }

    public void restoreState(FacesContext facesContext, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(facesContext, values[0]);
        if (values[1] instanceof AttachedDeltaWrapper) {
            ((StateHolder)this._actionListener).restoreState(facesContext, ((AttachedDeltaWrapper)values[1]).getWrappedStateObject());
        } else {
            this._actionListener = (MethodBinding)UISchedule.restoreAttachedState((FacesContext)facesContext, (Object)values[1]);
        }
        if (values[2] instanceof AttachedDeltaWrapper) {
            ((StateHolder)this._actionExpression).restoreState(facesContext, ((AttachedDeltaWrapper)values[2]).getWrappedStateObject());
        } else {
            this._actionExpression = (MethodExpression)UISchedule.restoreAttachedState((FacesContext)facesContext, (Object)values[2]);
        }
        if (values[3] instanceof AttachedDeltaWrapper) {
            ((StateHolder)this._mouseListenerExpression).restoreState(facesContext, ((AttachedDeltaWrapper)values[3]).getWrappedStateObject());
        } else {
            this._mouseListenerExpression = (MethodExpression)UISchedule.restoreAttachedState((FacesContext)facesContext, (Object)values[3]);
        }
    }

    public Object saveState(FacesContext facesContext) {
        if (this.initialStateMarked()) {
            boolean nullDelta = true;
            Object parentSaved = super.saveState(facesContext);
            Object actionListenerSaved = null;
            if (!this._isSetActionListener() && this._actionListener != null && this._actionListener instanceof PartialStateHolder) {
                StateHolder holder = (StateHolder)this._actionListener;
                if (!holder.isTransient()) {
                    Object attachedState = holder.saveState(facesContext);
                    if (attachedState != null) {
                        nullDelta = false;
                    }
                    actionListenerSaved = new AttachedDeltaWrapper(this._actionListener.getClass(), attachedState);
                }
            } else if (this._isSetActionListener() || this._actionListener != null) {
                actionListenerSaved = UISchedule.saveAttachedState((FacesContext)facesContext, (Object)this._actionListener);
                nullDelta = false;
            }
            Object actionExpressionSaved = null;
            if (!this._isSetActionExpression() && this._actionExpression != null && this._actionExpression instanceof PartialStateHolder) {
                StateHolder holder = (StateHolder)this._actionExpression;
                if (!holder.isTransient()) {
                    Object attachedState = holder.saveState(facesContext);
                    if (attachedState != null) {
                        nullDelta = false;
                    }
                    actionExpressionSaved = new AttachedDeltaWrapper(this._actionExpression.getClass(), attachedState);
                }
            } else if (this._isSetActionExpression() || this._actionExpression != null) {
                actionExpressionSaved = UISchedule.saveAttachedState((FacesContext)facesContext, (Object)this._actionExpression);
                nullDelta = false;
            }
            Object mouseListenerExpressionSaved = null;
            if (!this._isSetActionListener() && this._mouseListenerExpression != null && this._mouseListenerExpression instanceof PartialStateHolder) {
                StateHolder holder = (StateHolder)this._mouseListenerExpression;
                if (!holder.isTransient()) {
                    Object attachedState = holder.saveState(facesContext);
                    if (attachedState != null) {
                        nullDelta = false;
                    }
                    mouseListenerExpressionSaved = new AttachedDeltaWrapper(this._mouseListenerExpression.getClass(), attachedState);
                }
            } else if (this._isSetActionListener() || this._mouseListenerExpression != null) {
                mouseListenerExpressionSaved = UISchedule.saveAttachedState((FacesContext)facesContext, (Object)this._mouseListenerExpression);
                nullDelta = false;
            }
            if (parentSaved == null && nullDelta) {
                return null;
            }
            Object[] values = new Object[]{parentSaved, actionListenerSaved, actionExpressionSaved, mouseListenerExpressionSaved};
            return values;
        }
        Object[] values = new Object[]{super.saveState(facesContext), UISchedule.saveAttachedState((FacesContext)facesContext, (Object)this._actionListener), UISchedule.saveAttachedState((FacesContext)facesContext, (Object)this._actionExpression), UISchedule.saveAttachedState((FacesContext)facesContext, (Object)this._mouseListenerExpression)};
        return values;
    }

    public void setActionListener(MethodBinding actionListener) {
        this._actionListener = actionListener;
        if (this.initialStateMarked()) {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.actionListenerSet), (Object)Boolean.TRUE);
        }
    }

    private boolean _isSetActionListener() {
        Boolean value = (Boolean)this.getStateHelper().get((Serializable)((Object)PropertyKeys.actionListenerSet));
        return value == null ? false : value;
    }

    protected void setLastClickedDateAndTime(Date lastClickedDateAndTime) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lastClickedDateAndTime), (Object)lastClickedDateAndTime);
    }

    protected void setSubmittedEntry(ScheduleEntry submittedEntry) {
        this._submittedEntry = submittedEntry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        lastClickedDateAndTime,
        actionExpressionSet,
        actionListenerSet,
        mouseListenerExpressionSet;

    }

    private class ScheduleActionListener
    implements ActionListener {
        private ScheduleActionListener() {
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            UISchedule schedule = (UISchedule)event.getComponent();
            ScheduleEntry entry = schedule.getSubmittedEntry();
            schedule.getModel().setSelectedEntry(entry);
            schedule.setSubmittedEntry(null);
        }
    }
}

