/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.document;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.document.AbstractDocumentRenderer;
import org.apache.myfaces.custom.document.Document;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class DocumentRenderer
extends AbstractDocumentRenderer {
    public static final String RENDERER_TYPE = "org.apache.myfaces.Document";
    private String[] ATTRS = new String[]{"xmlns", "lang"};
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\r\n");

    protected String getHtmlTag() {
        return "html";
    }

    protected Class getDocumentClass() {
        return Document.class;
    }

    protected void openTag(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
        Document document = (Document)uiComponent;
        if (document.isIncludeBrowserSelectors()) {
            for (ConditionalCommentParts part : ConditionalCommentParts.values()) {
                writer.append((CharSequence)part.opening());
                this.openTagIntern(facesContext, writer, uiComponent);
                if (part.styleClass() != null) {
                    writer.writeAttribute("class", (Object)part.styleClass(), null);
                }
                writer.append((CharSequence)part.closing());
                writer.append((CharSequence)LINE_SEPARATOR);
            }
        } else {
            this.openTagIntern(facesContext, writer, uiComponent);
        }
    }

    private void openTagIntern(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
        super.openTag(facesContext, writer, uiComponent);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, this.ATTRS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConditionalCommentParts {
        IE6("<!--[if lt IE 7 ]>", "ie ie6", "<![endif]-->"),
        IE7("<!--[if IE 7 ]>", "ie ie7", "<![endif]-->"),
        IE8("<!--[if IE 8 ]>", "ie ie8", "<![endif]-->"),
        IE9("<!--[if IE 9 ]>", "ie ie9", "<![endif]-->"),
        DEFAULT("<!--[if (gt IE 9)|!(IE)]><!-->", null, "<!--<![endif]-->");

        private final String _opening;
        private final String _styleClass;
        private final String _closing;

        private ConditionalCommentParts(String opening, String styleClass, String closing) {
            this._opening = opening;
            this._styleClass = styleClass;
            this._closing = closing;
        }

        String opening() {
            return this._opening;
        }

        String styleClass() {
            return this._styleClass;
        }

        String closing() {
            return this._closing;
        }
    }
}

