/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class HtmlGroupRendererBase
extends HtmlRenderer {
    private static final String LAYOUT_BLOCK_VALUE = "block";

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map<String, List<ClientBehavior>> behaviors;
        ResponseWriter writer = context.getResponseWriter();
        boolean span = false;
        String layoutElement = "span";
        HtmlPanelGroup panelGroup = (HtmlPanelGroup)component;
        String layout = panelGroup.getLayout();
        if (layout != null && layout.equals(LAYOUT_BLOCK_VALUE)) {
            layoutElement = "div";
        }
        if ((behaviors = panelGroup.getClientBehaviors()) != null && !behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(context, writer);
        }
        if (!behaviors.isEmpty() || component.getId() != null && !component.getId().startsWith("j_id")) {
            span = true;
            writer.startElement(layoutElement, component);
            writer.writeAttribute("id", component.getClientId(context), null);
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(context)) {
                commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
                CommonPropertyUtils.renderCommonPassthroughPropertiesWithoutEvents(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.UNIVERSAL_ATTRIBUTES);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(context)) {
                CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, component);
            } else if (this.isCommonEventsOptimizationEnabled(context)) {
                CommonEventUtils.renderBehaviorizedEventHandlers(context, writer, commonPropertiesMarked, CommonEventUtils.getCommonEventsMarked(component), component, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(context, writer, component, behaviors);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(context)) {
            long commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
            if (commonPropertiesMarked > 0L) {
                span = true;
                writer.startElement(layoutElement, component);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, context);
                CommonPropertyUtils.renderCommonPassthroughProperties(writer, commonPropertiesMarked, component);
            }
        } else {
            span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, layoutElement, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
        }
        RendererUtils.renderChildren(context, component);
        if (span) {
            writer.endElement(layoutElement);
        }
    }
}

