/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;

class DualValueDeque
extends LinkedList<DualValue> {
    private RecursiveComparisonConfiguration recursiveComparisonConfiguration;

    public DualValueDeque(RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        this.recursiveComparisonConfiguration = recursiveComparisonConfiguration;
    }

    @Override
    public boolean add(DualValue dualKey) {
        if (this.shouldIgnore(dualKey)) {
            return false;
        }
        return super.add(dualKey);
    }

    @Override
    public void add(int index, DualValue dualKey) {
        if (this.shouldIgnore(dualKey)) {
            return;
        }
        super.add(index, dualKey);
    }

    @Override
    public boolean addAll(int index, Collection<? extends DualValue> collection) {
        return super.addAll(index, collection.stream().filter(this::shouldAddDualKey).collect(Collectors.toList()));
    }

    @Override
    public void addFirst(DualValue dualKey) {
        if (this.shouldIgnore(dualKey)) {
            return;
        }
        super.addFirst(dualKey);
    }

    @Override
    public void addLast(DualValue dualKey) {
        if (this.shouldIgnore(dualKey)) {
            return;
        }
        super.addLast(dualKey);
    }

    private boolean shouldIgnore(DualValue dualKey) {
        return this.recursiveComparisonConfiguration.shouldIgnore(dualKey);
    }

    private boolean shouldAddDualKey(DualValue dualKey) {
        return !this.shouldIgnore(dualKey);
    }
}

