/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/
package org.apache.kylin.common.metrics.common;

/**
 * This class defines some metrics generated by Kylin processes.
 */
public class MetricsConstant {

    public static final String API_PREFIX = "api_";
    public static final String ACTIVE_CALLS = "metrics:name=active_calls,method=";
    public static final String CALLS = "metrics:name=calls,method=";

    public static final String QUERY_SUCCESS_COUNT = "QuerySuccessCount";
    public static final String QUERY_FAIL_COUNT = "QueryFailCount";
    public static final String QUERY_CACHE_COUNT = "QueryCacheCount";
    public static final String QUERY_COUNT = "QueryCount";
    public static final String QUERY_DURATION = "QueryDuration";
    public static final String QUERY_RESULT_ROWCOUNT = "QueryResultRowcount";
    public static final String QUERY_SCAN_ROWCOUNT = "QueryScanRowcount";
    public static final String TOTAL = "total";

}