/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.apache.karaf.bundle.core.internal.BundleInfoImpl;
import org.apache.karaf.bundle.core.internal.BundleSelectorImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleServiceImpl
implements BundleService {
    private static Logger LOG = LoggerFactory.getLogger(BundleService.class);
    private static final String ORIGINAL_WIRES = "Original-Wires";
    private final BundleContext bundleContext;
    private final List<BundleStateService> stateServices;

    public BundleServiceImpl(BundleContext bundleContext, List<BundleStateService> stateServices) {
        this.bundleContext = bundleContext;
        this.stateServices = stateServices;
    }

    @Override
    public List<Bundle> selectBundles(List<String> ids, boolean defaultAllBundles) {
        return new BundleSelectorImpl(this.bundleContext).selectBundles(ids, defaultAllBundles);
    }

    @Override
    public Bundle getBundle(String id, boolean defaultAllBundles) {
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(id);
        List<Bundle> bundles = this.selectBundles(ids, defaultAllBundles);
        if (bundles.isEmpty()) {
            return null;
        }
        return bundles.get(0);
    }

    @Override
    public BundleInfo getInfo(Bundle bundle) {
        BundleState combinedState = BundleState.Unknown;
        for (BundleStateService stateService : this.stateServices) {
            BundleState extState = stateService.getState(bundle);
            if (extState == BundleState.Unknown) continue;
            combinedState = extState;
        }
        return new BundleInfoImpl(bundle, combinedState);
    }

    @Override
    public String getDiag(Bundle bundle) {
        StringBuilder message = new StringBuilder();
        for (BundleStateService bundleStateService : this.stateServices) {
            String part = bundleStateService.getDiag(bundle);
            if (part == null) continue;
            message.append(bundleStateService.getName() + "\n");
            message.append(part);
        }
        if (bundle.getState() == 2) {
            System.out.println("Unsatisfied Requirements:");
            List<BundleRequirement> reqs = this.getUnsatisfiedRquirements(bundle, null);
            for (BundleRequirement req : reqs) {
                System.out.println(req);
            }
        }
        return message.toString();
    }

    @Override
    public List<BundleRequirement> getUnsatisfiedRquirements(Bundle bundle, String namespace) {
        ArrayList<BundleRequirement> result = new ArrayList<BundleRequirement>();
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (rev != null) {
            List reqs = rev.getDeclaredRequirements(namespace);
            for (BundleRequirement req : reqs) {
                if (this.canBeSatisfied(req)) continue;
                result.add(req);
            }
        }
        return result;
    }

    private boolean canBeSatisfied(BundleRequirement req) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (wiring == null) continue;
            List caps = wiring.getCapabilities(null);
            for (BundleCapability cap : caps) {
                if (!req.matches(cap)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Bundle> getBundlesByURL(String urlFilter) {
        return new BundleSelectorImpl(this.bundleContext).getBundlesByURL(urlFilter);
    }

    @Override
    public void enableDynamicImports(Bundle bundle) {
        String location = String.format("wrap:%s$Bundle-UpdateLocation=%s&DynamicImport-Package=*&%s=%s&overwrite=merge", bundle.getLocation(), bundle.getLocation(), ORIGINAL_WIRES, this.explode(this.getWiredBundles(bundle).keySet()));
        LOG.debug(String.format("Updating %s with URL %s", bundle, location));
        try {
            URL url = new URL(location);
            bundle.update(url.openStream());
            ((FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class)).refreshBundles(Collections.singleton(bundle), new FrameworkListener[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error enabling dynamic imports on bundle" + bundle.getBundleId(), e);
        }
    }

    @Override
    public void disableDynamicImports(Bundle bundle) {
        Set<String> current = this.getWiredBundles(bundle).keySet();
        for (String original : ((String)bundle.getHeaders().get(ORIGINAL_WIRES)).toString().split(",")) {
            current.remove(original);
        }
        if (current.isEmpty()) {
            LOG.debug("No additional packages have been wired since dynamic import was enabled");
        } else {
            LOG.debug("Additional packages wired since dynamic import was enabled");
            for (String pkg : current) {
                LOG.debug("- " + pkg);
            }
        }
        try {
            bundle.update();
        }
        catch (BundleException e) {
            throw new RuntimeException("Error disabling dynamic imports on bundle" + bundle.getBundleId(), e);
        }
    }

    private String explode(Set<String> set) {
        StringBuffer result = new StringBuffer();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(",");
        }
        if (result.length() == 0) {
            return "--none--";
        }
        return result.toString();
    }

    @Override
    public Map<String, Bundle> getWiredBundles(Bundle bundle) {
        HashMap<String, Bundle> exporters = new HashMap<String, Bundle>();
        for (BundleRevision revision : ((BundleRevisions)bundle.adapt(BundleRevisions.class)).getRevisions()) {
            List wires;
            BundleWiring wiring = revision.getWiring();
            if (wiring == null || (wires = wiring.getRequiredWires("osgi.wiring.package")) == null) continue;
            for (BundleWire wire : wires) {
                if (wire.getProviderWiring().getBundle().getBundleId() == 0L) continue;
                exporters.put(wire.getCapability().getAttributes().get("osgi.wiring.package").toString(), wire.getProviderWiring().getBundle());
            }
        }
        return exporters;
    }

    @Override
    public boolean isDynamicImport(Bundle bundle) {
        return bundle.getHeaders().get(ORIGINAL_WIRES) != null;
    }
}

