/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.help.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.karaf.shell.console.HelpProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class HelpSystem
implements HelpProvider {
    private BundleContext context;

    public HelpSystem(BundleContext context) {
        this.context = context;
    }

    public synchronized List<HelpProvider> getProviders() {
        Object[] refs = null;
        try {
            refs = this.context.getServiceReferences(HelpProvider.class, null).toArray(new ServiceReference[0]);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        Arrays.sort(refs);
        ArrayList<HelpProvider> providers = new ArrayList<HelpProvider>();
        for (int i = refs.length - 1; i >= 0; --i) {
            providers.add((HelpProvider)this.context.getService((ServiceReference)refs[i]));
        }
        return providers;
    }

    public String getHelp(final CommandSession session, String path) {
        if (path == null) {
            path = "%root%";
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("data", "${" + path + "}");
        final List<HelpProvider> providers = this.getProviders();
        InterpolationHelper.performSubstitution(props, new InterpolationHelper.SubstitutionCallback(){

            @Override
            public String getValue(String key) {
                for (HelpProvider hp : providers) {
                    String result = hp.getHelp(session, key);
                    if (result == null) continue;
                    return HelpSystem.this.removeNewLine(result);
                }
                return null;
            }
        });
        return (String)props.get("data");
    }

    private String removeNewLine(String help) {
        if (help != null && help.endsWith("\n")) {
            help = help.substring(0, help.length() - 1);
        }
        return help;
    }
}

