/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SessionListener;
import org.apache.sshd.common.session.AbstractSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTimeoutListener
implements SessionListener,
Runnable {
    private final Logger log = LoggerFactory.getLogger(SessionTimeoutListener.class);
    private final Set<AbstractSession> sessions = new CopyOnWriteArraySet<AbstractSession>();

    public void sessionCreated(Session session) {
        if (session instanceof AbstractSession && (session.getAuthTimeout() > 0L || session.getIdleTimeout() > 0L)) {
            this.sessions.add((AbstractSession)session);
        }
    }

    public void sessionEvent(Session session, SessionListener.Event event) {
    }

    public void sessionClosed(Session s) {
        this.sessions.remove(s);
    }

    public void run() {
        for (AbstractSession session : this.sessions) {
            try {
                session.checkForTimeouts();
            }
            catch (Exception e) {
                this.log.warn("An error occurred while checking session timeouts", (Throwable)e);
            }
        }
    }
}

