/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.serializer.SerializationContext;

public abstract class QueryIter2
extends QueryIter {
    private QueryIterator leftInput;
    private QueryIterator rightInput;

    public QueryIter2(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        super(execCxt);
        this.leftInput = left;
        this.rightInput = right;
    }

    protected QueryIterator getLeft() {
        return this.leftInput;
    }

    protected QueryIterator getRight() {
        return this.rightInput;
    }

    @Override
    protected final void closeIterator() {
        this.closeSubIterator();
        QueryIter2.performClose(this.leftInput);
        QueryIter2.performClose(this.rightInput);
        this.leftInput = null;
        this.rightInput = null;
    }

    @Override
    protected final void requestCancel() {
        this.requestSubCancel();
        QueryIter2.performRequestCancel(this.leftInput);
        QueryIter2.performRequestCancel(this.rightInput);
    }

    protected abstract void requestSubCancel();

    protected abstract void closeSubIterator();

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(Lib.className((Object)this));
        out.incIndent();
        out.print("(");
        out.incIndent();
        this.getLeft().output(out, sCxt);
        out.decIndent();
        out.println(")");
        out.print("(");
        out.incIndent();
        this.getRight().output(out, sCxt);
        out.decIndent();
        out.println(")");
        out.decIndent();
    }
}

