/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.AllCapabilities;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public interface Graph {
    public static final Graph emptyGraph = new GraphBase(){

        @Override
        public ExtendedIterator<Triple> graphBaseFind(Triple tm) {
            return NullIterator.instance();
        }
    };

    @Deprecated(forRemoval=true)
    public boolean dependsOn(Graph var1);

    public TransactionHandler getTransactionHandler();

    @Deprecated(forRemoval=true)
    default public Capabilities getCapabilities() {
        return AllCapabilities.updateAllowed;
    }

    public GraphEventManager getEventManager();

    public PrefixMapping getPrefixMapping();

    public void add(Triple var1) throws AddDeniedException;

    default public void add(Node s, Node p, Node o) throws AddDeniedException {
        Objects.requireNonNull(s, "Subject must not be null");
        Objects.requireNonNull(p, "Predicate must not be null");
        Objects.requireNonNull(o, "Object must not be null");
        this.add(Triple.create(s, p, o));
    }

    public void delete(Triple var1) throws DeleteDeniedException;

    default public void delete(Node s, Node p, Node o) throws DeleteDeniedException {
        Objects.requireNonNull(s, "Subject must not be null");
        Objects.requireNonNull(p, "Predicate must not be null");
        Objects.requireNonNull(o, "Object must not be null");
        this.delete(Triple.create(s, p, o));
    }

    public ExtendedIterator<Triple> find(Triple var1);

    public ExtendedIterator<Triple> find(Node var1, Node var2, Node var3);

    default public Stream<Triple> stream(Node s, Node p, Node o) {
        return Iter.asStream(this.find(s, p, o));
    }

    default public Stream<Triple> stream() {
        return this.stream(Node.ANY, Node.ANY, Node.ANY);
    }

    default public ExtendedIterator<Triple> find() {
        return this.find(Node.ANY, Node.ANY, Node.ANY);
    }

    public boolean isIsomorphicWith(Graph var1);

    public boolean contains(Node var1, Node var2, Node var3);

    public boolean contains(Triple var1);

    public void clear();

    public void remove(Node var1, Node var2, Node var3);

    public void close();

    public boolean isEmpty();

    public int size();

    default public long sizeLong() {
        return this.size();
    }

    public boolean isClosed();
}

