/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class TransferSubscriptionsRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=839");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=841");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=840");
    private final RequestHeader requestHeader;
    private final UInteger[] subscriptionIds;
    private final Boolean sendInitialValues;

    public TransferSubscriptionsRequest(RequestHeader requestHeader, UInteger[] subscriptionIds, Boolean sendInitialValues) {
        this.requestHeader = requestHeader;
        this.subscriptionIds = subscriptionIds;
        this.sendInitialValues = sendInitialValues;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger[] getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public Boolean getSendInitialValues() {
        return this.sendInitialValues;
    }

    protected TransferSubscriptionsRequest(TransferSubscriptionsRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((TransferSubscriptionsRequestBuilder)b).requestHeader;
        this.subscriptionIds = ((TransferSubscriptionsRequestBuilder)b).subscriptionIds;
        this.sendInitialValues = ((TransferSubscriptionsRequestBuilder)b).sendInitialValues;
    }

    public static TransferSubscriptionsRequestBuilder<?, ?> builder() {
        return new TransferSubscriptionsRequestBuilderImpl();
    }

    public TransferSubscriptionsRequestBuilder<?, ?> toBuilder() {
        return new TransferSubscriptionsRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferSubscriptionsRequest)) {
            return false;
        }
        TransferSubscriptionsRequest other = (TransferSubscriptionsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$sendInitialValues = this.getSendInitialValues();
        Boolean other$sendInitialValues = other.getSendInitialValues();
        if (this$sendInitialValues == null ? other$sendInitialValues != null : !((Object)this$sendInitialValues).equals(other$sendInitialValues)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getSubscriptionIds(), other.getSubscriptionIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransferSubscriptionsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $sendInitialValues = this.getSendInitialValues();
        result = result * 59 + ($sendInitialValues == null ? 43 : ((Object)$sendInitialValues).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSubscriptionIds());
        return result;
    }

    @Override
    public String toString() {
        return "TransferSubscriptionsRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionIds=" + Arrays.deepToString(this.getSubscriptionIds()) + ", sendInitialValues=" + this.getSendInitialValues() + ")";
    }

    private static final class TransferSubscriptionsRequestBuilderImpl
    extends TransferSubscriptionsRequestBuilder<TransferSubscriptionsRequest, TransferSubscriptionsRequestBuilderImpl> {
        private TransferSubscriptionsRequestBuilderImpl() {
        }

        @Override
        protected TransferSubscriptionsRequestBuilderImpl self() {
            return this;
        }

        @Override
        public TransferSubscriptionsRequest build() {
            return new TransferSubscriptionsRequest(this);
        }
    }

    public static abstract class TransferSubscriptionsRequestBuilder<C extends TransferSubscriptionsRequest, B extends TransferSubscriptionsRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger[] subscriptionIds;
        private Boolean sendInitialValues;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TransferSubscriptionsRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TransferSubscriptionsRequest instance, TransferSubscriptionsRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionIds(instance.subscriptionIds);
            b.sendInitialValues(instance.sendInitialValues);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionIds(UInteger[] subscriptionIds) {
            this.subscriptionIds = subscriptionIds;
            return (B)this.self();
        }

        public B sendInitialValues(Boolean sendInitialValues) {
            this.sendInitialValues = sendInitialValues;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TransferSubscriptionsRequest.TransferSubscriptionsRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionIds=" + Arrays.deepToString(this.subscriptionIds) + ", sendInitialValues=" + this.sendInitialValues + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<TransferSubscriptionsRequest> {
        @Override
        public Class<TransferSubscriptionsRequest> getType() {
            return TransferSubscriptionsRequest.class;
        }

        @Override
        public TransferSubscriptionsRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger[] subscriptionIds = decoder.readUInt32Array("SubscriptionIds");
            Boolean sendInitialValues = decoder.readBoolean("SendInitialValues");
            return new TransferSubscriptionsRequest(requestHeader, subscriptionIds, sendInitialValues);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, TransferSubscriptionsRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32Array("SubscriptionIds", value.getSubscriptionIds());
            encoder.writeBoolean("SendInitialValues", value.getSendInitialValues());
        }
    }
}

