/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.tsfile.read.common.block.TsBlock;

public class AscFloatTypeJoinKeyComparator
implements JoinKeyComparator {
    private static final AscFloatTypeJoinKeyComparator INSTANCE = new AscFloatTypeJoinKeyComparator();

    private AscFloatTypeJoinKeyComparator() {
    }

    public static AscFloatTypeJoinKeyComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public Optional<Boolean> lessThan(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getFloat(leftRowIndex) < right.getColumn(rightColumnIndex).getFloat(rightRowIndex));
    }

    @Override
    public Optional<Boolean> equalsTo(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getFloat(leftRowIndex) == right.getColumn(rightColumnIndex).getFloat(rightRowIndex));
    }

    @Override
    public Optional<Boolean> lessThanOrEqual(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getFloat(leftRowIndex) <= right.getColumn(rightColumnIndex).getFloat(rightRowIndex));
    }
}

