/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.compressor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.config.constant.PipeSinkConstant;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeCompressor;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeCompressorConfig;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeGZIPCompressor;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeLZ4Compressor;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeLZMA2Compressor;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeSnappyCompressor;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeZSTDCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeCompressorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeCompressorFactory.class);
    private static final Map<String, PipeCompressor> COMPRESSOR_NAME_TO_INSTANCE = new ConcurrentHashMap<String, PipeCompressor>();
    private static Map<Byte, PipeCompressor> COMPRESSOR_INDEX_TO_INSTANCE;

    public static PipeCompressor getCompressor(PipeCompressorConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("PipeCompressorConfig is null");
        }
        if (config.getName() == null) {
            throw new IllegalArgumentException("PipeCompressorConfig.getName() is null");
        }
        String compressorName = config.getName();
        if (compressorName.equals("zstd")) {
            int zstdCompressionLevel = config.getZstdCompressionLevel();
            return COMPRESSOR_NAME_TO_INSTANCE.computeIfAbsent("zstd_" + zstdCompressionLevel, key -> {
                LOGGER.info("Create new PipeZSTDCompressor with level: {}", (Object)zstdCompressionLevel);
                return new PipeZSTDCompressor(zstdCompressionLevel);
            });
        }
        PipeCompressor compressor = COMPRESSOR_NAME_TO_INSTANCE.get(compressorName);
        if (compressor != null) {
            return compressor;
        }
        throw new UnsupportedOperationException("PipeCompressor not found for name: " + compressorName);
    }

    public static PipeCompressor getCompressor(byte index) {
        PipeCompressor compressor = COMPRESSOR_INDEX_TO_INSTANCE.get(index);
        if (compressor == null) {
            throw new UnsupportedOperationException("PipeCompressor not found for index: " + index);
        }
        return compressor;
    }

    private PipeCompressorFactory() {
    }

    static {
        COMPRESSOR_NAME_TO_INSTANCE.put("snappy", new PipeSnappyCompressor());
        COMPRESSOR_NAME_TO_INSTANCE.put("gzip", new PipeGZIPCompressor());
        COMPRESSOR_NAME_TO_INSTANCE.put("lz4", new PipeLZ4Compressor());
        COMPRESSOR_NAME_TO_INSTANCE.put("zstd", new PipeZSTDCompressor(PipeSinkConstant.CONNECTOR_COMPRESSOR_ZSTD_LEVEL_DEFAULT_VALUE));
        COMPRESSOR_NAME_TO_INSTANCE.put("lzma2", new PipeLZMA2Compressor());
        COMPRESSOR_INDEX_TO_INSTANCE = new HashMap<Byte, PipeCompressor>();
        COMPRESSOR_INDEX_TO_INSTANCE.put(PipeCompressor.PipeCompressionType.SNAPPY.getIndex(), COMPRESSOR_NAME_TO_INSTANCE.get("snappy"));
        COMPRESSOR_INDEX_TO_INSTANCE.put(PipeCompressor.PipeCompressionType.GZIP.getIndex(), COMPRESSOR_NAME_TO_INSTANCE.get("gzip"));
        COMPRESSOR_INDEX_TO_INSTANCE.put(PipeCompressor.PipeCompressionType.LZ4.getIndex(), COMPRESSOR_NAME_TO_INSTANCE.get("lz4"));
        COMPRESSOR_INDEX_TO_INSTANCE.put(PipeCompressor.PipeCompressionType.ZSTD.getIndex(), COMPRESSOR_NAME_TO_INSTANCE.get("zstd"));
        COMPRESSOR_INDEX_TO_INSTANCE.put(PipeCompressor.PipeCompressionType.LZMA2.getIndex(), COMPRESSOR_NAME_TO_INSTANCE.get("lzma2"));
        COMPRESSOR_INDEX_TO_INSTANCE = Collections.unmodifiableMap(COMPRESSOR_INDEX_TO_INSTANCE);
    }
}

