/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metrics.sources;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.function.DoubleSupplier;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metrics.MetricSet;
import org.apache.ignite3.internal.metrics.MetricSetBuilder;
import org.apache.ignite3.internal.metrics.MetricSource;
import org.jetbrains.annotations.Nullable;

public class OsMetricSource
implements MetricSource {
    private final IgniteLogger log = Loggers.forClass(OsMetricSource.class);
    private static final String SOURCE_NAME = "os";
    private final java.lang.management.OperatingSystemMXBean operatingSystemMxBean;
    private boolean enabled;

    OsMetricSource(java.lang.management.OperatingSystemMXBean operatingSystemMxBean) {
        this.operatingSystemMxBean = operatingSystemMxBean;
    }

    public OsMetricSource() {
        this(ManagementFactory.getOperatingSystemMXBean());
    }

    @Override
    public String name() {
        return SOURCE_NAME;
    }

    @Override
    @Nullable
    public synchronized MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        MetricSetBuilder metricSetBuilder = new MetricSetBuilder(SOURCE_NAME);
        metricSetBuilder.doubleGauge("LoadAverage", "System load average for the last minute. System load average is the sum of the number of runnable entities queued to the available processors and the number of runnable entities running on the available processors averaged over a period of time. The way in which the load average is calculated depends on the operating system. If the load average is not available, a negative value is returned.", this.operatingSystemMxBean::getSystemLoadAverage);
        metricSetBuilder.doubleGauge("CpuLoad", "CPU load. The value is between 0.0 and 1.0, where 0.0 means no CPU load and 1.0 means 100% CPU load.If the CPU load is not available, a negative value is returned.", this.cpuLoadSupplier());
        this.enabled = true;
        return metricSetBuilder.build();
    }

    @Override
    public synchronized void disable() {
        this.enabled = false;
    }

    @Override
    public synchronized boolean enabled() {
        return this.enabled;
    }

    private DoubleSupplier cpuLoadSupplier() {
        try {
            if (this.operatingSystemMxBean instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean sunOs = (OperatingSystemMXBean)this.operatingSystemMxBean;
                return sunOs::getProcessCpuLoad;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.log.warn("The 'com.sun.management.OperatingSystemMXBean' class is not available for class loader. CPU metrics are not available.", new Object[0]);
        return () -> -1.0;
    }
}

