/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.marshaller;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.table.ClientColumn;
import org.apache.ignite3.internal.marshaller.MarshallerReader;
import org.jetbrains.annotations.Nullable;

public class ClientMarshallerReader
implements MarshallerReader {
    private final BinaryTupleReader unpacker;
    private final ClientColumn @Nullable [] columns;
    private final TuplePart part;
    private int index;

    public ClientMarshallerReader(BinaryTupleReader unpacker, ClientColumn @Nullable [] columns, TuplePart part) {
        this.unpacker = unpacker;
        this.columns = columns;
        this.part = part;
    }

    @Override
    public void skipValue() {
        ++this.index;
    }

    @Override
    public boolean readBoolean() {
        return this.unpacker.booleanValue(this.nextSchemaIndex());
    }

    @Override
    public Boolean readBooleanBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Boolean.valueOf(this.unpacker.booleanValue(idx));
    }

    @Override
    public byte readByte() {
        return this.unpacker.byteValue(this.nextSchemaIndex());
    }

    @Override
    public Byte readByteBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Byte.valueOf(this.unpacker.byteValue(idx));
    }

    @Override
    public short readShort() {
        return this.unpacker.shortValue(this.nextSchemaIndex());
    }

    @Override
    public Short readShortBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Short.valueOf(this.unpacker.shortValue(idx));
    }

    @Override
    public int readInt() {
        return this.unpacker.intValue(this.nextSchemaIndex());
    }

    @Override
    public Integer readIntBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Integer.valueOf(this.unpacker.intValue(idx));
    }

    @Override
    public long readLong() {
        return this.unpacker.longValue(this.nextSchemaIndex());
    }

    @Override
    public Long readLongBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Long.valueOf(this.unpacker.longValue(idx));
    }

    @Override
    public float readFloat() {
        return this.unpacker.floatValue(this.nextSchemaIndex());
    }

    @Override
    public Float readFloatBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Float.valueOf(this.unpacker.floatValue(idx));
    }

    @Override
    public double readDouble() {
        return this.unpacker.doubleValue(this.nextSchemaIndex());
    }

    @Override
    public Double readDoubleBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Double.valueOf(this.unpacker.doubleValue(idx));
    }

    @Override
    public String readString() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.stringValue(idx);
    }

    @Override
    public UUID readUuid() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.uuidValue(idx);
    }

    @Override
    public byte[] readBytes() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.bytesValue(idx);
    }

    @Override
    public BigDecimal readBigDecimal(int scale) {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.decimalValue(idx, scale);
    }

    @Override
    public LocalDate readDate() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.dateValue(idx);
    }

    @Override
    public LocalTime readTime() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.timeValue(idx);
    }

    @Override
    public Instant readTimestamp() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.timestampValue(idx);
    }

    @Override
    public LocalDateTime readDateTime() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.dateTimeValue(idx);
    }

    private int nextSchemaIndex() {
        int i = this.index++;
        if (this.columns == null) {
            return i;
        }
        switch (this.part) {
            case KEY: {
                return this.columns[i].keyIndex();
            }
            case VAL: {
                return this.columns[i].valIndex();
            }
        }
        return this.columns[i].schemaIndex();
    }
}

