/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.logit.storage.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.Lifecycle;
import org.apache.ignite.raft.jraft.storage.logit.storage.db.AbstractDB;
import org.apache.ignite.raft.jraft.storage.logit.storage.factory.LogStoreFactory;
import org.apache.ignite.raft.jraft.storage.logit.storage.service.AllocateFileService;
import org.apache.ignite.raft.jraft.storage.logit.util.concurrent.ShutdownAbleThread;

public class ServiceManager
implements Lifecycle<LogStoreFactory> {
    private static final IgniteLogger LOG = Loggers.forClass(ServiceManager.class);
    private final AbstractDB abstractDB;
    private AllocateFileService allocateService;
    private List<ShutdownAbleThread> serviceList;
    private final AtomicBoolean start = new AtomicBoolean(false);

    public ServiceManager(AbstractDB abstractDB) {
        this.abstractDB = abstractDB;
    }

    @Override
    public boolean init(LogStoreFactory logStoreFactory) {
        this.allocateService = logStoreFactory.newAllocateService(this.abstractDB);
        this.serviceList = new ArrayList<ShutdownAbleThread>(1);
        this.serviceList.add(this.allocateService);
        return true;
    }

    public void start() {
        if (!this.start.compareAndSet(false, true)) {
            return;
        }
        for (ShutdownAbleThread serviceThread : this.serviceList) {
            serviceThread.start();
        }
    }

    @Override
    public void shutdown() {
        if (!this.start.compareAndSet(true, false)) {
            return;
        }
        try {
            this.allocateService.shutdown(true);
        }
        catch (Exception e) {
            LOG.error("Error on shutdown {}'s serviceManager,", new Object[]{this.abstractDB.getDBName(), e});
        }
    }

    public AllocateFileService getAllocateService() {
        return this.allocateService;
    }
}

