/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import org.apache.ignite.raft.jraft.core.State;

public enum LocalPartitionStateEnum {
    UNAVAILABLE(0),
    HEALTHY(1),
    INITIALIZING(2),
    INSTALLING_SNAPSHOT(3),
    CATCHING_UP(4),
    BROKEN(5);

    private final int id;

    public static LocalPartitionStateEnum convert(State raftNodeState) {
        switch (raftNodeState) {
            case STATE_LEADER: 
            case STATE_TRANSFERRING: 
            case STATE_CANDIDATE: 
            case STATE_FOLLOWER: {
                return HEALTHY;
            }
            case STATE_ERROR: {
                return BROKEN;
            }
            case STATE_UNINITIALIZED: {
                return INITIALIZING;
            }
            case STATE_SHUTTING: 
            case STATE_SHUTDOWN: 
            case STATE_END: {
                return UNAVAILABLE;
            }
        }
        return BROKEN;
    }

    private LocalPartitionStateEnum(int id) {
        this.id = id;
    }

    public static LocalPartitionStateEnum fromId(int id) throws IllegalArgumentException {
        switch (id) {
            case 0: {
                return UNAVAILABLE;
            }
            case 1: {
                return HEALTHY;
            }
            case 2: {
                return INITIALIZING;
            }
            case 3: {
                return INSTALLING_SNAPSHOT;
            }
            case 4: {
                return CATCHING_UP;
            }
            case 5: {
                return BROKEN;
            }
        }
        throw new IllegalArgumentException("No enum constant from id: " + id);
    }

    public int id() {
        return this.id;
    }
}

